/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.logs;

import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ManagedActor;
import com.xebialabs.xlrelease.domain.events.TaskJobExecutedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.features.TaskExecutionLogsFeature$;
import com.xebialabs.xlrelease.scheduler.events.JobFinishedEvent;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatchActor;
import com.xebialabs.xlrelease.scheduler.logs.ExecutionLogWatcherSupervisor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntry$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionEntryDebounceActor;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLog;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionLogService$;
import com.xebialabs.xlrelease.scheduler.logs.TaskExecutionRepository;
import com.xebialabs.xlrelease.scheduler.logs.TaskLogCreated;
import com.xebialabs.xlrelease.storage.domain.LogEntry;
import com.xebialabs.xlrelease.storage.domain.StorageEntry;
import com.xebialabs.xlrelease.storage.service.LogSizeLimitExceededException;
import com.xebialabs.xlrelease.storage.service.StorageService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.TaskExecutionLogView;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Marker;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\tMa\u0001B\u000e\u001d\u0001\u001dB\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!Aa\t\u0001B\u0001B\u0003%q\tC\u0003L\u0001\u0011\u0005A\n\u0003\u0005R\u0001!\u0015\r\u0011\"\u0003S\u0011!I\u0006\u0001#b\u0001\n\u0013\u0011\u0006\"\u0002.\u0001\t\u0003Y\u0006\"\u00028\u0001\t\u0003y\u0007\"B9\u0001\t\u0003\u0011\bbBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!!\u001c\u0001\t\u0013\ty\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u000f\u0005\u001d\u0005\u0001\"\u0001\u0002\n\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006bBA\\\u0001\u0011\u0005\u0011\u0011X\u0004\b\u0003Sd\u0002\u0012AAv\r\u0019YB\u0004#\u0001\u0002n\"11j\u0005C\u0001\u0003_D\u0011\"!=\u0014\u0005\u0004%\t!a=\t\u0011\u0005m8\u0003)A\u0005\u0003kD\u0011\"!@\u0014\u0005\u0004%\t!a@\t\u0011\t-1\u0003)A\u0005\u0005\u0003A\u0011B!\u0004\u0014\u0005\u0004%IAa\u0004\t\u0011\tE1\u0003)A\u0005\u0003c\u0011q\u0003V1tW\u0016CXmY;uS>tGj\\4TKJ4\u0018nY3\u000b\u0005uq\u0012\u0001\u00027pONT!a\b\u0011\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0011#\u0003%AHN]3mK\u0006\u001cXM\u0003\u0002$I\u0005I\u00010\u001a2jC2\f'm\u001d\u0006\u0002K\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u000b\u0018\u0011\u0005%bS\"\u0001\u0016\u000b\u0003-\nQa]2bY\u0006L!!\f\u0016\u0003\r\u0005s\u0017PU3g!\tyC'D\u00011\u0015\t\t$'A\u0003tY\u001a$$NC\u00014\u0003!9'/\u001b>{Y\u0016$\u0017BA\u001b1\u0005\u001daunZ4j]\u001e\f\u0011#Y2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s!\tA4(D\u0001:\u0015\tQ\u0004%\u0001\u0004bGR|'o]\u0005\u0003ye\u0012\u0011#Q2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s\u00039\u0019Ho\u001c:bO\u0016\u001cVM\u001d<jG\u0016\u0004\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\u000fM,'O^5dK*\u00111\tI\u0001\bgR|'/Y4f\u0013\t)\u0005I\u0001\bTi>\u0014\u0018mZ3TKJ4\u0018nY3\u0002/Q\f7o[#yK\u000e,H/[8o%\u0016\u0004xn]5u_JL\bC\u0001%J\u001b\u0005a\u0012B\u0001&\u001d\u0005]!\u0016m]6Fq\u0016\u001cW\u000f^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\u0004=S:LGO\u0010\u000b\u0005\u001b:{\u0005\u000b\u0005\u0002I\u0001!)a\u0007\u0002a\u0001o!)Q\b\u0002a\u0001}!)a\t\u0002a\u0001\u000f\u0006YR\r_3dkRLwN\u001c'pO^\u000bGo\u00195fe\u0006\u001bGo\u001c:SK\u001a,\u0012a\u0015\t\u0004qQ3\u0016BA+:\u00051i\u0015M\\1hK\u0012\f5\r^8s!\tIs+\u0003\u0002YU\t9aj\u001c;iS:<\u0017A\t;bg.,\u00050Z2vi&|g.\u00128uef$UMY8v]\u000e,\u0017i\u0019;peJ+g-A\u0003xCR\u001c\u0007\u000eF\u0002]?2\u0004\"!K/\n\u0005yS#\u0001B+oSRDQ\u0001Y\u0004A\u0002\u0005\fa\u0001^1tW&#\u0007C\u00012j\u001d\t\u0019w\r\u0005\u0002eU5\tQM\u0003\u0002gM\u00051AH]8pizJ!\u0001\u001b\u0016\u0002\rA\u0013X\rZ3g\u0013\tQ7N\u0001\u0004TiJLgn\u001a\u0006\u0003Q*BQ!\\\u0004A\u0002\u0005\f1\"\u001a=fGV$\u0018n\u001c8JI\u0006I1\u000f^8q/\u0006$8\r\u001b\u000b\u00039BDQ!\u001c\u0005A\u0002\u0005\fQAZ3uG\"$r\u0001X:uk~\fi\u0003C\u0003a\u0013\u0001\u0007\u0011\rC\u0003n\u0013\u0001\u0007\u0011\rC\u0003w\u0013\u0001\u0007q/\u0001\u0007pkR\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0002y{6\t\u0011P\u0003\u0002{w\u0006\u0011\u0011n\u001c\u0006\u0002y\u0006!!.\u0019<b\u0013\tq\u0018P\u0001\u0007PkR\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002\u0002%\u0001\r!a\u0001\u0002\u000f1\f7\u000f\u001e&pEB!\u0011QAA\u0014\u001d\u0011\t9!!\t\u000f\t\u0005%\u00111\u0004\b\u0005\u0003\u0017\t9B\u0004\u0003\u0002\u000e\u0005Ua\u0002BA\b\u0003'q1\u0001ZA\t\u0013\u0005)\u0013BA\u0012%\u0013\t\t#%C\u0002\u0002\u001a\u0001\naA];o]\u0016\u0014\u0018\u0002BA\u000f\u0003?\ta\u0001Z8nC&t'bAA\rA%!\u00111EA\u0013\u0003\u001d\u0001\u0018mY6bO\u0016TA!!\b\u0002 %!\u0011\u0011FA\u0016\u0005\u0015QuNY%e\u0015\u0011\t\u0019#!\n\t\u000f\u0005=\u0012\u00021\u0001\u00022\u0005IA.Y:u\u0007\",hn\u001b\t\u0004S\u0005M\u0012bAA\u001bU\t!Aj\u001c8h\u0003\u0011\u0001xN\\4\u0015\u0007q\u000bY\u0004C\u0003n\u0015\u0001\u0007\u0011-\u0001\ngKR\u001c\u0007.\u00117m\u000bb,7-\u001e;j_:\u001cH\u0003BA!\u00033\u0002b!a\u0011\u0002J\u00055SBAA#\u0015\r\t9e_\u0001\u0005kRLG.\u0003\u0003\u0002L\u0005\u0015#\u0001\u0002'jgR\u0004B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\u0002\u0013!\u0002<jK^\u001c\u0018\u0002BA,\u0003#\u0012A\u0003V1tW\u0016CXmY;uS>tGj\\4WS\u0016<\b\"\u00021\f\u0001\u0004\t\u0017a\u00017pOR\u0019A,a\u0018\t\u000f\u0005\u0005D\u00021\u0001\u0002d\u0005AAn\\4F]R\u0014\u0018\u0010\u0005\u0003\u0002f\u0005%TBAA4\u0015\r\tiBQ\u0005\u0005\u0003W\n9G\u0001\u0005M_\u001e,e\u000e\u001e:z\u0003=!(/\u001f+sk:\u001c\u0017\r^3M_\u001e\u001cH\u0003BA2\u0003cBq!!\u0019\u000e\u0001\u0004\t\u0019'A\u000bhKR$\u0016m]6Fq\u0016\u001cW\u000f^5p]\u0016sGO]=\u0015\r\u0005]\u00141QAC!\u0015I\u0013\u0011PA?\u0013\r\tYH\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007!\u000by(C\u0002\u0002\u0002r\u0011!\u0003V1tW\u0016CXmY;uS>tWI\u001c;ss\")\u0001M\u0004a\u0001C\")QN\u0004a\u0001C\u0006iqN\u001c&pE\u001aKg.[:iK\u0012$2\u0001XAF\u0011\u001d\tii\u0004a\u0001\u0003\u001f\u000bQ!\u001a<f]R\u0004B!!%\u0002\u00186\u0011\u00111\u0013\u0006\u0004\u0003+s\u0012AB3wK:$8/\u0003\u0003\u0002\u001a\u0006M%\u0001\u0005&pE\u001aKg.[:iK\u0012,e/\u001a8uQ\ry\u0011Q\u0014\t\u0005\u0003?\u000b\u0019+\u0004\u0002\u0002\"*\u0019\u0011Q\u0013\u0011\n\t\u0005\u0015\u0016\u0011\u0015\u0002\n'V\u00147o\u0019:jE\u0016\f\u0001c\u001c8UCN\\Gj\\4De\u0016\fG/\u001a3\u0015\u0007q\u000bY\u000bC\u0004\u0002.B\u0001\r!a,\u0002\u0019Q\f7o\u001b'pO\u00163XM\u001c;\u0011\u0007!\u000b\t,C\u0002\u00024r\u0011a\u0002V1tW2{wm\u0011:fCR,G\rK\u0002\u0011\u0003;\u000b1c\u001c8UCN\\W\t_3dkRLwN\u001c#p]\u0016$2\u0001XA^\u0011\u001d\ti)\u0005a\u0001\u0003{\u0003B!a0\u0002F6\u0011\u0011\u0011\u0019\u0006\u0005\u0003+\u000b\u0019MC\u0002\u0002\u001e\u0001JA!a2\u0002B\n!B+Y:l\u0015>\u0014W\t_3dkR,G-\u0012<f]RD3!EAOQ\r\u0001\u0011Q\u001a\t\u0005\u0003\u001f\fi.\u0004\u0002\u0002R*!\u00111[Ak\u0003)\u0019H/\u001a:f_RL\b/\u001a\u0006\u0005\u0003/\fI.A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\t\tY.A\u0002pe\u001eLA!a8\u0002R\n91+\u001a:wS\u000e,\u0007f\u0001\u0001\u0002dB!\u0011qTAs\u0013\u0011\t9/!)\u0003\u001b\u00153XM\u001c;MSN$XM\\3s\u0003]!\u0016m]6Fq\u0016\u001cW\u000f^5p]2{wmU3sm&\u001cW\r\u0005\u0002I'M\u00111\u0003\u000b\u000b\u0003\u0003W\f\u0011\u0004R#G\u0003VcEkX\"I+:[uLQ+G\r\u0016\u0013vlU%[\u000bV\u0011\u0011Q\u001f\t\u0004S\u0005]\u0018bAA}U\t\u0019\u0011J\u001c;\u00025\u0011+e)Q+M)~\u001b\u0005*\u0016(L?\n+fIR#S?NK%,\u0012\u0011\u0002)1{ui\u0018+S+:\u001b\u0015\tV#`\u001b\u0016\u001b6+Q$F+\t\u0011\t\u0001\u0005\u0003\u0003\u0004\t%QB\u0001B\u0003\u0015\r\u00119a_\u0001\u0005Y\u0006tw-C\u0002k\u0005\u000b\tQ\u0003T(H?R\u0013VKT\"B)\u0016{V*R*T\u0003\u001e+\u0005%A\rM\u001f\u001e{FKU+O\u0007\u0006#ViX'F'N\u000bu)R0T\u0013j+UCAA\u0019\u0003iaujR0U%Vs5)\u0011+F?6+5kU!H\u000b~\u001b\u0016JW#!\u0001")
public class TaskExecutionLogService
implements Logging {
    private ManagedActor<Nothing$> executionLogWatcherActorRef;
    private ManagedActor<Nothing$> taskExecutionEntryDebounceActorRef;
    private final ActorSystemHolder actorSystemHolder;
    private final StorageService storageService;
    private final TaskExecutionRepository taskExecutionRepository;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static String LOG_TRUNCATE_MESSAGE() {
        return TaskExecutionLogService$.MODULE$.LOG_TRUNCATE_MESSAGE();
    }

    public static int DEFAULT_CHUNK_BUFFER_SIZE() {
        return TaskExecutionLogService$.MODULE$.DEFAULT_CHUNK_BUFFER_SIZE();
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private ManagedActor<Nothing$> executionLogWatcherActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.executionLogWatcherActorRef = this.actorSystemHolder.actorOf(ExecutionLogWatcherSupervisor.class, "execution-log-watchers");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.executionLogWatcherActorRef;
    }

    private ManagedActor<Nothing$> executionLogWatcherActorRef() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.executionLogWatcherActorRef$lzycompute();
        }
        return this.executionLogWatcherActorRef;
    }

    private ManagedActor<Nothing$> taskExecutionEntryDebounceActorRef$lzycompute() {
        TaskExecutionLogService taskExecutionLogService = this;
        synchronized (taskExecutionLogService) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.taskExecutionEntryDebounceActorRef = this.actorSystemHolder.actorOf(TaskExecutionEntryDebounceActor.class, "task-execution-entry-debounce-actor");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.taskExecutionEntryDebounceActorRef;
    }

    private ManagedActor<Nothing$> taskExecutionEntryDebounceActorRef() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.taskExecutionEntryDebounceActorRef$lzycompute();
        }
        return this.taskExecutionEntryDebounceActorRef;
    }

    public void watch(String taskId, String executionId) {
        ExecutionLogWatchActor.StartWatch x$1 = new ExecutionLogWatchActor.StartWatch(taskId, executionId, User.AUTHENTICATED_USER.getName());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2(x$1);
        this.executionLogWatcherActorRef().$bang(x$1, x$2);
    }

    public void stopWatch(String executionId) {
        ExecutionLogWatchActor.StopWatching x$1 = new ExecutionLogWatchActor.StopWatching(executionId, (Option<String>)new Some((Object)User.AUTHENTICATED_USER.getName()));
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2(x$1);
        this.executionLogWatcherActorRef().$bang(x$1, x$2);
    }

    public void fetch(String taskId, String executionId, OutputStream outputStream, long lastJob, long lastChunk) {
        new TaskExecutionLog(taskId, executionId).fetch(this.storageService, outputStream, lastJob, lastChunk);
    }

    public void pong(String executionId) {
        ExecutionLogWatchActor.Pong x$1 = new ExecutionLogWatchActor.Pong(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2(x$1);
        this.executionLogWatcherActorRef().$bang(x$1, x$2);
    }

    public java.util.List<TaskExecutionLogView> fetchAllExecutions(String taskId) {
        return CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.taskExecutionRepository.find(new TaskExecutionRepository.ByTaskId(taskId), Pageable.unpaged()).getContent()).asScala().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long l;
                TaskExecutionEntry row = (TaskExecutionEntry)tuple2._1();
                int index = tuple2._2$mcI$sp();
                TaskExecutionLogView view = new TaskExecutionLogView();
                view.setId(row.executionId());
                view.setExecutionNo(Predef$.MODULE$.int2Integer(index + 1));
                view.setLastJob(Predef$.MODULE$.long2Long((long)row.lastJob()));
                view.setLastChunk(Predef$.MODULE$.int2Integer(row.lastChunk()));
                Option option = Option$.MODULE$.apply((Object)row.lastModifiedDate());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Instant date2 = (Instant)some.value();
                    l = date2.toEpochMilli();
                } else if (None$.MODULE$.equals(option)) {
                    l = Instant.now().toEpochMilli();
                } else {
                    throw new MatchError((Object)option);
                }
                long modifiedDate = l;
                view.setModifiedDate(Predef$.MODULE$.long2Long(modifiedDate));
                row.endDate().foreach((Function1 & Serializable)date -> {
                    view.setEndDate(Predef$.MODULE$.long2Long(date.toEpochMilli()));
                    return BoxedUnit.UNIT;
                });
                return view;
            }
            throw new MatchError((Object)tuple2);
        })).asJava();
    }

    public void log(LogEntry logEntry) {
        Option x$1 = Option$.MODULE$.apply((Object)this.storageService.defaultStorageType());
        String x$2 = logEntry.copy$default$1();
        String x$3 = logEntry.copy$default$2();
        long x$4 = logEntry.copy$default$3();
        long x$5 = logEntry.copy$default$4();
        String x$6 = logEntry.copy$default$5();
        byte[] x$7 = logEntry.copy$default$6();
        LogEntry workerLogEntry = logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$1);
        workerLogEntry = TaskExecutionLogsFeature$.MODULE$.isLogTruncationEnabled() ? this.tryTruncateLogs(workerLogEntry) : workerLogEntry;
        URI uri = this.storageService.store((StorageEntry)workerLogEntry);
        TaskExecutionEntryDebounceActor.DebounceTaskExecutionEntry x$8 = new TaskExecutionEntryDebounceActor.DebounceTaskExecutionEntry(new TaskExecutionEntryDebounceActor.TaskExecutionKey(logEntry.taskId(), logEntry.executionId()), TaskExecutionEntry$.MODULE$.from(workerLogEntry, TaskExecutionEntry$.MODULE$.from$default$2()), (List<URI>)new .colon.colon((Object)uri, (List)Nil$.MODULE$));
        ActorRef x$9 = this.taskExecutionEntryDebounceActorRef().$bang$default$2(x$8);
        this.taskExecutionEntryDebounceActorRef().$bang(x$8, x$9);
    }

    private LogEntry tryTruncateLogs(LogEntry logEntry) {
        long maxSize = TaskExecutionLogsFeature$.MODULE$.getMaxSizeInBytes();
        return (LogEntry)this.taskExecutionRepository.read(logEntry.taskId(), logEntry.executionId()).map((Function1 & Serializable)taskExecutionEntry -> {
            Tuple2 tuple2;
            if (taskExecutionEntry.truncated()) {
                throw new LogSizeLimitExceededException("Log size limit exceeded for task " + logEntry.taskId() + " and execution " + logEntry.executionId());
            }
            long currentSize = taskExecutionEntry.logSize();
            if (currentSize > maxSize) {
                byte[] payload = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps(logEntry.payload()), (Object)TaskExecutionLogService$.MODULE$.LOG_TRUNCATE_MESSAGE().getBytes(StandardCharsets.UTF_8), (ClassTag)ClassTag$.MODULE$.Byte());
                v0 = new Tuple2((Object)payload, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else if (currentSize + (long)logEntry.payload().length > maxSize) {
                long bytesLeft = maxSize - currentSize - TaskExecutionLogService$.MODULE$.com$xebialabs$xlrelease$scheduler$logs$TaskExecutionLogService$$LOG_TRUNCATE_MESSAGE_SIZE();
                byte[] payload = (byte[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(logEntry.payload()), (int)bytesLeft)), (Object)TaskExecutionLogService$.MODULE$.LOG_TRUNCATE_MESSAGE().getBytes(StandardCharsets.UTF_8), (ClassTag)ClassTag$.MODULE$.Byte());
                v0 = new Tuple2((Object)payload, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else {
                v0 = tuple2 = new Tuple2((Object)logEntry.payload(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
            }
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            byte[] payload = (byte[])tuple2._1();
            boolean truncate = tuple2._2$mcZ$sp();
            Tuple2 tuple22 = new Tuple2((Object)payload, (Object)BoxesRunTime.boxToBoolean((boolean)truncate));
            byte[] payload2 = (byte[])tuple22._1();
            boolean truncate2 = tuple22._2$mcZ$sp();
            if (truncate2) {
                $this.taskExecutionRepository.markAsTruncated(logEntry.taskId(), logEntry.executionId());
            }
            byte[] x$1 = payload2;
            String x$2 = logEntry.copy$default$1();
            String x$3 = logEntry.copy$default$2();
            long x$4 = logEntry.copy$default$3();
            long x$5 = logEntry.copy$default$4();
            String x$6 = logEntry.copy$default$5();
            Option x$7 = logEntry.copy$default$7();
            return logEntry.copy(x$2, x$3, x$4, x$5, x$6, x$1, x$7);
        }).getOrElse((Function0 & Serializable)() -> logEntry);
    }

    public Option<TaskExecutionEntry> getTaskExecutionEntry(String taskId, String executionId) {
        return this.taskExecutionRepository.read(taskId, executionId);
    }

    @Subscribe
    public void onJobFinished(JobFinishedEvent event) {
        long jobId = event.jobId();
        String executionId = event.executionId();
        this.logger().debug((Function0 & Serializable)() -> "finishing job " + jobId);
        ExecutionLogWatchActor.Check x$1 = new ExecutionLogWatchActor.Check(executionId);
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2(x$1);
        this.executionLogWatcherActorRef().$bang(x$1, x$2);
    }

    @Subscribe
    public void onTaskLogCreated(TaskLogCreated taskLogEvent) {
        this.logger().debug((Function0 & Serializable)() -> "processing log event " + taskLogEvent);
        ExecutionLogWatchActor.NewEntry x$1 = new ExecutionLogWatchActor.NewEntry(taskLogEvent.executionId(), taskLogEvent.uris());
        ActorRef x$2 = this.executionLogWatcherActorRef().$bang$default$2(x$1);
        this.executionLogWatcherActorRef().$bang(x$1, x$2);
    }

    @Subscribe
    public void onTaskExecutionDone(TaskJobExecutedEvent event) {
        this.taskExecutionRepository.finishExecution(event.taskId(), event.executionId(), Instant.now());
    }

    public TaskExecutionLogService(ActorSystemHolder actorSystemHolder, StorageService storageService, TaskExecutionRepository taskExecutionRepository) {
        this.actorSystemHolder = actorSystemHolder;
        this.storageService = storageService;
        this.taskExecutionRepository = taskExecutionRepository;
        Logging.$init$((Logging)this);
    }
}

