/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.JobConfirmationActor;
import com.xebialabs.xlrelease.actors.JobConfirmed;
import com.xebialabs.xlrelease.actors.ManagedActor;
import com.xebialabs.xlrelease.actors.MonitorJobConfirmation;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.features.JobSchedulerFeature$;
import com.xebialabs.xlrelease.features.settings.JobSchedulerStrategySettings;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.DefaultJobQueue;
import com.xebialabs.xlrelease.scheduler.FailJob;
import com.xebialabs.xlrelease.scheduler.Job;
import com.xebialabs.xlrelease.scheduler.JobProvider;
import com.xebialabs.xlrelease.scheduler.JobQueue;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobRunnerQueue;
import com.xebialabs.xlrelease.scheduler.RunnerRegistry;
import com.xebialabs.xlrelease.scheduler.StopWorkerThread;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.scheduler.domain.LocalJobRunner$;
import com.xebialabs.xlrelease.scheduler.strategies.LimitParallelJobSchedulerStrategySettings;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.pekko.actor.ActorRef;
import org.slf4j.Marker;
import org.springframework.context.annotation.Primary;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.stereotype.Component;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Primary
@Component
@ScalaSignature(bytes="\u0006\u0005\t5d\u0001B\u0012%\u00015B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\t\u0015\u0002\u0011)\u0019!C\u0001\u0017\"A!\u000b\u0001B\u0001B\u0003%A\n\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\"\u00020\u0001\t\u0003y\u0006\u0002C3\u0001\u0011\u000b\u0007I\u0011\u00024\t\u000f5\u0004!\u0019!C\u0005]\"9\u0011\u0011\u0006\u0001!\u0002\u0013y\u0007bBA\u0016\u0001\u0011\u0005\u0013Q\u0006\u0005\b\u0003\u000b\u0002A\u0011IA$\u0011\u001d\t\t\u0006\u0001C#\u0003'Bq!a\u001d\u0001\t\u0013\t)\bC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u0005e\u0006\u0001\"\u0003\u0002<\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAf\u0001\u0011\u0005\u0013Q\u001a\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\t\t\u000f\u0001C\u0005\u0003GDq!!>\u0001\t\u0003\n9\u0010C\u0004\u0002|\u0002!\t%!@\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!q\u0001\u0001\u0005B\t%\u0001b\u0002B\u0007\u0001\u0011\u0005#q\u0002\u0005\b\u0005'\u0001A\u0011\tB\u000b\u0011\u001d\u0011I\u0002\u0001C!\u00057AqA!\b\u0001\t\u0003\u0012Y\u0002C\u0004\u0003 \u0001!\tE!\t\t\u000f\t\r\u0002\u0001\"\u0011\u0003&!9!Q\u0006\u0001\u0005\n\tm\u0001b\u0002B\u0018\u0001\u0011%!\u0011\u0007\u0005\b\u0005k\u0001A\u0011\u0002B\u001c\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{AqA!\u0011\u0001\t\u0003\u0012\u0019EA\fDCB\f'-\u001b7jif\fu/\u0019:f\u0015>\u0014\u0017+^3vK*\u0011QEJ\u0001\ng\u000eDW\rZ;mKJT!a\n\u0015\u0002\u0013ad'/\u001a7fCN,'BA\u0015+\u0003%AXMY5bY\u0006\u00147OC\u0001,\u0003\r\u0019w.\\\u0002\u0001'\u0019\u0001a\u0006\u000e\u001d<}A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0004\"!\u000e\u001c\u000e\u0003\u0011J!a\u000e\u0013\u0003\u0011){'-U;fk\u0016\u0004\"!N\u001d\n\u0005i\"#A\u0004*v]:,'OU3hSN$(/\u001f\t\u0003kqJ!!\u0010\u0013\u0003\u0017){'\r\u0015:pm&$WM\u001d\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQa\u001d7gi)T\u0011aQ\u0001\tOJL'P\u001f7fI&\u0011Q\t\u0011\u0002\b\u0019><w-\u001b8h\u0003!QwNY)vKV,\u0007CA\u001bI\u0013\tIEEA\bEK\u001a\fW\u000f\u001c;K_\n\fV/Z;f\u0003MQwN\u0019*v]:,'OU3q_NLGo\u001c:z+\u0005a\u0005CA'Q\u001b\u0005q%BA('\u0003)\u0011X\r]8tSR|'/_\u0005\u0003#:\u00131CS8c%Vtg.\u001a:SKB|7/\u001b;pef\fAC[8c%Vtg.\u001a:SKB|7/\u001b;pef\u0004\u0013a\u0005:fY\u0016\f7/Z!di>\u00148+\u001a:wS\u000e,\u0007CA+Y\u001b\u00051&BA,'\u0003\u0019\t7\r^8sg&\u0011\u0011L\u0016\u0002\u0014%\u0016dW-Y:f\u0003\u000e$xN]*feZL7-Z\u0001\u0012C\u000e$xN]*zgR,W\u000eS8mI\u0016\u0014\bCA+]\u0013\tifKA\tBGR|'oU=ti\u0016l\u0007j\u001c7eKJ\fa\u0001P5oSRtD#\u00021bE\u000e$\u0007CA\u001b\u0001\u0011\u00151e\u00011\u0001H\u0011\u0015Qe\u00011\u0001M\u0011\u0015\u0019f\u00011\u0001U\u0011\u0015Qf\u00011\u0001\\\u0003!\t7\r^8s%\u00164W#A4\u0011\u0007UC'.\u0003\u0002j-\naQ*\u00198bO\u0016$\u0017i\u0019;peB\u0011qf[\u0005\u0003YB\u0012qAT8uQ&tw-\u0001\u0007sk:tWM])vKV,7/F\u0001p!\u0015\u0001x/_A\u0012\u001b\u0005\t(B\u0001:t\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003iV\fA!\u001e;jY*\ta/\u0001\u0003kCZ\f\u0017B\u0001=r\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0004u\u0006uabA>\u0002\u00189\u0019A0!\u0005\u000f\u0007u\fiAD\u0002\u007f\u0003\u0017q1a`A\u0005\u001d\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003Y\u00051AH]8pizJ\u0011aK\u0005\u0003S)J!a\n\u0015\n\u0007\u0005=a%\u0001\u0004sk:tWM]\u0005\u0005\u0003'\t)\"\u0001\u0004e_6\f\u0017N\u001c\u0006\u0004\u0003\u001f1\u0013\u0002BA\r\u00037\tq\u0001]1dW\u0006<WM\u0003\u0003\u0002\u0014\u0005U\u0011\u0002BA\u0010\u0003C\u0011\u0001BU;o]\u0016\u0014\u0018\n\u001a\u0006\u0005\u00033\tY\u0002E\u00026\u0003KI1!a\n%\u00059QuN\u0019*v]:,'/U;fk\u0016\fQB];o]\u0016\u0014\u0018+^3vKN\u0004\u0013!\u0005:fO&\u001cH/\u001a:K_\n\u0014VO\u001c8feR!\u0011qFA\u001b!\ry\u0013\u0011G\u0005\u0004\u0003g\u0001$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003oQ\u0001\u0019AA\u001d\u0003%QwN\u0019*v]:,'\u000f\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\u0011\ty!a\u0010\u000b\u0007\u0005Ma%\u0003\u0003\u0002D\u0005u\"!\u0003&pEJ+hN\\3s\u0003M)hN]3hSN$XM\u001d&pEJ+hN\\3s)\u0011\tI%a\u0014\u0011\u0007=\nY%C\u0002\u0002NA\u0012A!\u00168ji\"9\u0011qG\u0006A\u0002\u0005e\u0012aA4fiR!\u0011QKA1!\u0015y\u0013qKA.\u0013\r\tI\u0006\r\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007U\ni&C\u0002\u0002`\u0011\u00121AS8c\u0011\u0019\t\u0019\u0007\u0004a\u0001s\u0006A!/\u001e8oKJLE\rK\u0002\r\u0003O\u0002B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0004\u0003[\u0002\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011OA6\u0005\u001d!\u0018-\u001b7sK\u000e\fa\u0002Z3mCf|%OU3tKJ4X\r\u0006\u0004\u0002V\u0005]\u0014Q\u0013\u0005\b\u0003sj\u0001\u0019AA>\u0003\u001d!\u0018m]6K_\n\u0004D!! \u0002\bB)Q'a \u0002\u0004&\u0019\u0011\u0011\u0011\u0013\u0003\u000fQ\u000b7o\u001b&pEB!\u0011QQAD\u0019\u0001!A\"!#\u0002x\u0005\u0005\t\u0011!B\u0001\u0003\u0017\u00131a\u0018\u00132#\rQ\u0017Q\u0012\t\u0005\u0003\u001f\u000b\t*\u0004\u0002\u0002@%!\u00111SA \u0005\u0011!\u0016m]6\t\r\u0005\rT\u00021\u0001z\u0003!!W\r\\1z\u0015>\u0014G\u0003BA%\u00037Cq!!(\u000f\u0001\u0004\ty*A\u0002k_\n\u0004B!!)\u00024:!\u00111UAW\u001d\u0011\t)+!+\u000f\u0007u\f9+\u0003\u0002&M%\u0019\u00111\u0016\u0013\u0002\u0015M$(/\u0019;fO&,7/\u0003\u0003\u00020\u0006E\u0016\u0001\u0006&pEN\u001b\u0007.\u001a3vY\u0016\u00148\u000b\u001e:bi\u0016<\u0017PC\u0002\u0002,\u0012JA!!.\u00028\nQA)\u001a7bs\u0016$'j\u001c2\u000b\t\u0005=\u0016\u0011W\u0001\u000be\u0016\u001cXM\u001d<f\u0015>\u0014GCBA+\u0003{\u000b\t\rC\u0004\u0002@>\u0001\r!a\u0017\u0002\u0017A|7o]5cY\u0016TuN\u0019\u0005\u0007\u0003Gz\u0001\u0019A=\u0002\u000fI,7/\u001a:wKR1\u00111LAd\u0003\u0013Dq!a0\u0011\u0001\u0004\tY\u0006\u0003\u0004\u0002dA\u0001\r!_\u0001\bG>tg-\u001b:n)\u0019\ty#a4\u0002R\"1\u00111M\tA\u0002eDq!a5\u0012\u0001\u0004\t).A\u0003k_\nLE\rE\u0002{\u0003/LA!!7\u0002\"\t)!j\u001c2JI\u00061rN\u001a4feR{'j\u001c2Sk:tWM])vKV,7\u000f\u0006\u0003\u0002J\u0005}\u0007bBAO%\u0001\u0007\u00111L\u0001\u001ae\u0016lwN^3Ge>l'j\u001c2Sk:tWM])vKV,7\u000f\u0006\u0003\u0002J\u0005\u0015\bbBAt'\u0001\u0007\u0011\u0011^\u0001\naJ,G-[2bi\u0016\u0004b!a;\u0002r\u0006mSBAAw\u0015\r\tyo]\u0001\tMVt7\r^5p]&!\u00111_Aw\u0005%\u0001&/\u001a3jG\u0006$X-\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u0003\u0013\nI\u0010C\u0004\u0002\u001eR\u0001\r!a\u0017\u0002\u001dM,(-\\5u\u000bbL7\u000f^5oOR!\u0011\u0011JA\u0000\u0011\u001d\ti*\u0006a\u0001\u00037\n\u0011c];c[&$(I]8bI\u000e\f7\u000f^3e)\u0011\tIE!\u0002\t\u000f\u0005ue\u00031\u0001\u0002\\\u00059!/\u001a9mC\u000e,G\u0003BA%\u0005\u0017Aq!!(\u0018\u0001\u0004\tY&\u0001\u0004gS:L7\u000f\u001b\u000b\u0005\u0003\u0013\u0012\t\u0002C\u0004\u0002Tb\u0001\r!!6\u0002\u0011\r\fgnY3m\u0013\u001a$B!!\u0013\u0003\u0018!9\u0011q]\rA\u0002\u0005%\u0018!B:uCJ$HCAA%\u0003\u0011\u0019Ho\u001c9\u0002\u0013%\u001c(+\u001e8oS:<GCAA\u0018\u0003\u0011\u0019\u0018N_3\u0015\u0005\t\u001d\u0002cA\u0018\u0003*%\u0019!1\u0006\u0019\u0003\u0007%sG/\u0001\nsK\u001eL7\u000f^3s\u0015>\u0014'+\u001e8oKJ\u001c\u0018!E2sK\u0006$XMU;o]\u0016\u0014\u0018+^3vKR!\u0011\u0011\nB\u001a\u0011\u001d\tya\ba\u0001\u0003s\t\u0011C]3n_Z,'+\u001e8oKJ\fV/Z;f)\u0011\tIE!\u000f\t\u000f\u0005=\u0001\u00051\u0001\u0002:\u0005!R\u000f\u001d3bi\u0016$\u0016m]6Ti\u0006$Xo\u001d'j]\u0016$B!!\u0013\u0003@!9\u0011QT\u0011A\u0002\u0005m\u0013!C;o%\u0016\u001cXM\u001d<f)\u0011\tIE!\u0012\t\u000f\u0005u%\u00051\u0001\u0002\\!\u001a\u0001A!\u0013\u0011\t\t-#1L\u0007\u0003\u0005\u001bRA!!\u001c\u0003P)!!\u0011\u000bB*\u0003\u001d\u0019wN\u001c;fqRTAA!\u0016\u0003X\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0003Z\u0005\u0019qN]4\n\t\tu#Q\n\u0002\b!JLW.\u0019:zQ\r\u0001!\u0011\r\t\u0005\u0005G\u0012I'\u0004\u0002\u0003f)!!q\rB*\u0003)\u0019H/\u001a:f_RL\b/Z\u0005\u0005\u0005W\u0012)GA\u0005D_6\u0004xN\\3oi\u0002")
public class CapabilityAwareJobQueue
implements JobQueue,
RunnerRegistry,
JobProvider,
Logging {
    private ManagedActor<Nothing$> actorRef;
    private final DefaultJobQueue jobQueue;
    private final JobRunnerRepository jobRunnerRepository;
    private final ReleaseActorService releaseActorService;
    private ActorSystemHolder actorSystemHolder;
    private final ConcurrentHashMap<String, JobRunnerQueue> runnerQueues;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public JobRunnerRepository jobRunnerRepository() {
        return this.jobRunnerRepository;
    }

    private ManagedActor<Nothing$> actorRef$lzycompute() {
        CapabilityAwareJobQueue capabilityAwareJobQueue = this;
        synchronized (capabilityAwareJobQueue) {
            if (!this.bitmap$0) {
                this.actorRef = this.actorSystemHolder.actorOf(JobConfirmationActor.class, "jobConfirmationActor");
                this.bitmap$0 = true;
            }
        }
        this.actorSystemHolder = null;
        return this.actorRef;
    }

    private ManagedActor<Nothing$> actorRef() {
        if (!this.bitmap$0) {
            return this.actorRef$lzycompute();
        }
        return this.actorRef;
    }

    private ConcurrentHashMap<String, JobRunnerQueue> runnerQueues() {
        return this.runnerQueues;
    }

    @Override
    public boolean registerJobRunner(JobRunner jobRunner) {
        boolean updateInQueue;
        Option runnerQueue = Option$.MODULE$.apply((Object)this.runnerQueues().get(jobRunner.getId()));
        boolean bl = updateInQueue = runnerQueue.isEmpty() || runnerQueue.nonEmpty() && ((JobRunnerQueue)runnerQueue.get()).isOutdated(jobRunner);
        if (updateInQueue) {
            this.logger().debug((Function0 & Serializable)() -> "Going to register runner[" + jobRunner.getId() + "]");
            this.createRunnerQueue(jobRunner);
        } else {
            this.logger().debug((Function0 & Serializable)() -> "Runner already in queue, skipping registration for runner[" + jobRunner.getId() + "]");
        }
        return updateInQueue;
    }

    @Override
    public void unregisterJobRunner(JobRunner jobRunner) {
        this.logger().debug((Function0 & Serializable)() -> "Going to un-register runner[" + jobRunner.getId() + "]");
        this.removeRunnerQueue(jobRunner);
    }

    @Override
    public final Option<Job> get(String runnerId) {
        Option s;
        Option option;
        while ((option = (s = Option$.MODULE$.apply((Object)this.runnerQueues().get(runnerId)))) instanceof Some) {
            Some some = (Some)option;
            JobRunnerQueue runnerQueue = (JobRunnerQueue)some.value();
            Option option2 = Option$.MODULE$.apply((Object)runnerQueue.poll());
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Job possibleJob = (Job)some2.value();
                Job job = possibleJob;
                if (job instanceof StopWorkerThread) {
                    StopWorkerThread stopWorkerThread = (StopWorkerThread)job;
                    return new Some((Object)stopWorkerThread);
                }
                if (job instanceof FailJob) {
                    FailJob failJob = (FailJob)job;
                    return new Some((Object)failJob);
                }
                if (job instanceof TaskJob) {
                    TaskJob taskJob = (TaskJob)job;
                    Option<Job> reservedJob = this.delayOrReserve(taskJob, runnerId);
                    Option<Job> option3 = reservedJob;
                    if (None$.MODULE$.equals(option3)) continue;
                    return option3;
                }
                throw new MatchError((Object)job);
            }
            throw new MatchError((Object)option2);
        }
        if (None$.MODULE$.equals(option)) {
            String msg = "No runner queue found for " + runnerId;
            this.logger().warn((Function0 & Serializable)() -> msg);
            throw new NotFoundException(msg, new Object[0]);
        }
        throw new MatchError((Object)option);
    }

    private Option<Job> delayOrReserve(TaskJob<? extends Task> taskJob, String runnerId) {
        Either<Job, Job> maybeDelayed = JobSchedulerFeature$.MODULE$.strategy().schedule(taskJob);
        Either<Job, Job> either = maybeDelayed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Job delayedTaskJob = (Job)left.value();
            this.delayJob(delayedTaskJob);
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Job job = (Job)right.value();
            Option<Job> maybeReservedJob = this.reserveJob(job, runnerId);
            if (maybeReservedJob.isEmpty()) {
                JobSchedulerFeature$.MODULE$.strategy().unlock(taskJob.id(), (Option<String>)Option$.MODULE$.apply((Object)taskJob.taskId()));
            }
            return maybeReservedJob;
        }
        throw new MatchError(either);
    }

    private void delayJob(Job job) {
        this.logger().debug((Function0 & Serializable)() -> "delaying job " + job.id());
        Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            JobSchedulerStrategySettings jobSchedulerStrategySettings = JobSchedulerFeature$.MODULE$.strategy();
            if (jobSchedulerStrategySettings instanceof LimitParallelJobSchedulerStrategySettings) {
                this.submitBroadcasted(job);
                return;
            }
            this.replace(job);
        }).recover((PartialFunction)new Serializable(this, job){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ CapabilityAwareJobQueue $outer;
            private final Job job$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.logger().error((Function0 & Serializable)() -> "Unable to delay job " + $this.job$1, (Function0 & Serializable)() -> A1);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.job$1 = job$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(com.xebialabs.xlrelease.scheduler.CapabilityAwareJobQueue$$anonfun$delayJob$3 ), $anonfun$applyOrElse$2(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    private Option<Job> reserveJob(Job possibleJob, String runnerId) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> this.reserve(possibleJob, runnerId));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Job reservedJob = (Job)success.value();
            this.logger().debug((Function0 & Serializable)() -> "giving " + reservedJob);
            this.updateTaskStatusLine(reservedJob);
            return new Some((Object)reservedJob);
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            Throwable throwable = exception;
            if (throwable instanceof OptimisticLockingFailureException) {
                this.logger().debug((Function0 & Serializable)() -> "Unable to reserve job " + possibleJob);
                return None$.MODULE$;
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                this.logger().error((Function0 & Serializable)() -> "Unexpected error", (Function0 & Serializable)() -> throwable2);
                FailJob failJob = new FailJob(possibleJob, (Option<String>)new Some((Object)throwable2.getMessage()));
                this.runnerQueues().get(LocalJobRunner$.MODULE$.getId()).offer(failJob);
                return None$.MODULE$;
            }
            throw new MatchError((Object)throwable);
        }
        throw new MatchError((Object)try_);
    }

    private Job reserve(Job possibleJob, String runnerId) {
        Job job = this.jobQueue.reserve(possibleJob, runnerId);
        this.removeFromJobRunnerQueues(x$1 -> x$1.id() == possibleJob.id());
        MonitorJobConfirmation x$12 = new MonitorJobConfirmation(job);
        ActorRef x$2 = this.actorRef().$bang$default$2(x$12);
        this.actorRef().$bang(x$12, x$2);
        return job;
    }

    @Override
    public boolean confirm(String runnerId, long jobId) {
        boolean result;
        block1: {
            JobConfirmed x$1 = new JobConfirmed(jobId);
            ActorRef x$2 = this.actorRef().$bang$default$2(x$1);
            this.actorRef().$bang(x$1, x$2);
            Tuple2<Object, Option<TaskJob<?>>> tuple2 = this.jobQueue.confirm(runnerId, jobId);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean result2 = tuple2._1$mcZ$sp();
            Option taskJob = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)result2), (Object)taskJob);
            result = tuple22._1$mcZ$sp();
            Option taskJob2 = (Option)tuple22._2();
            if (!result || !taskJob2.isDefined()) break block1;
            this.updateTaskStatusLine((Job)taskJob2.get());
        }
        return result;
    }

    private void offerToJobRunnerQueues(Job job) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeFromJobRunnerQueues(Predicate<Job> predicate) {
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.runnerQueues().values().iterator()).asScala().foreach((Function1 & Serializable)subscriber -> {
            subscriber.cancelIf(predicate);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void submit(Job job) {
        this.jobQueue.submit(job);
        this.updateTaskStatusLine(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitExisting(Job job) {
        this.jobQueue.submitExisting(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void submitBroadcasted(Job job) {
        this.jobQueue.submitBroadcasted(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void replace(Job job) {
        this.jobQueue.replace(job);
        this.offerToJobRunnerQueues(job);
    }

    @Override
    public void finish(long jobId) {
        Option<JobRow> maybeJobRow = this.jobQueue.finish(jobId);
        maybeJobRow.foreach((Function1 & Serializable)jobRow -> {
            CapabilityAwareJobQueue.$anonfun$finish$1(jobRow);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void cancelIf(Predicate<Job> predicate) {
        this.jobQueue.cancelIf(predicate);
        this.removeFromJobRunnerQueues(predicate);
    }

    @Override
    public void start() {
        this.registerJobRunners();
        this.jobQueue.start();
    }

    @Override
    public void stop() {
        this.jobQueue.stop();
    }

    @Override
    public boolean isRunning() {
        return this.jobQueue.isRunning();
    }

    @Override
    public int size() {
        return this.jobQueue.size();
    }

    private void registerJobRunners() {
        List<? extends JobRunner> jobRunners = this.jobRunnerRepository().findAll();
        jobRunners.forEach(runner -> this.createRunnerQueue((JobRunner)runner));
    }

    private void createRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
        JobRunnerQueue runnerQueue = new JobRunnerQueue((Set<String>)CollectionConverters$.MODULE$.SetHasAsScala(runner.getCapabilities()).asScala().toSet(), runner.capacity(), runner.evictionTime(), runner.idleTimeToLive(), (String)Option$.MODULE$.apply((Object)runner.registrySettings()).map((Function1 & Serializable)x$3 -> x$3.getId()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        this.runnerQueues().put(runner.getId(), runnerQueue);
        this.logger().debug((Function0 & Serializable)() -> "Created runner queue for runner [" + runner.getId() + "]");
        CollectionConverters$.MODULE$.IteratorHasAsScala(this.jobQueue.localJobs().iterator()).asScala().foreach((Function1 & Serializable)job -> {
            runnerQueue.offer(job);
            return BoxedUnit.UNIT;
        });
    }

    private void removeRunnerQueue(JobRunner runner) {
        this.runnerQueues().remove(runner.getId());
    }

    private void updateTaskStatusLine(Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            taskJob.jobStatusLine().foreach((Function1 & Serializable)statusLine -> {
                this.releaseActorService.updateTaskStatusLine(taskJob.taskId(), statusLine);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    @Override
    public void unReserve(Job job) {
        Job job2 = job;
        if (job2 instanceof TaskJob) {
            TaskJob taskJob = (TaskJob)job2;
            JobSchedulerFeature$.MODULE$.strategy().unlock(taskJob.id(), (Option<String>)Option$.MODULE$.apply((Object)taskJob.taskId()));
        }
        Job unReservedJob = this.jobQueue.unReserve(job);
        this.updateTaskStatusLine(unReservedJob);
        this.replace(unReservedJob);
    }

    public static final /* synthetic */ void $anonfun$finish$1(JobRow jobRow) {
        JobSchedulerFeature$.MODULE$.strategy().unlock(jobRow.id(), (Option<String>)Option$.MODULE$.apply((Object)jobRow.taskId()));
    }

    public CapabilityAwareJobQueue(DefaultJobQueue jobQueue, JobRunnerRepository jobRunnerRepository, ReleaseActorService releaseActorService, ActorSystemHolder actorSystemHolder) {
        this.jobQueue = jobQueue;
        this.jobRunnerRepository = jobRunnerRepository;
        this.releaseActorService = releaseActorService;
        this.actorSystemHolder = actorSystemHolder;
        Logging.$init$((Logging)this);
        this.runnerQueues = new ConcurrentHashMap();
        this.createRunnerQueue(LocalJobRunner$.MODULE$);
    }
}

