/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.actors.kryoserializers.javakaffee.jodatime;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.xebialabs.xlrelease.actors.kryoserializers.javakaffee.jodatime.IdentifiableChronology;
import org.joda.time.Chronology;
import org.joda.time.LocalDate;

public class JodaLocalDateSerializer
extends Serializer<LocalDate> {
    public JodaLocalDateSerializer() {
        this.setImmutable(true);
    }

    public LocalDate read(Kryo kryo, Input input, Class<? extends LocalDate> type) {
        int packedYearMonthDay = input.readInt(true);
        Chronology chronology = IdentifiableChronology.readChronology(input);
        return new LocalDate(packedYearMonthDay / 416, packedYearMonthDay % 416 / 32, packedYearMonthDay % 32, chronology);
    }

    public void write(Kryo kryo, Output output, LocalDate localDate) {
        int packedYearMonthDay = localDate.getYear() * 13 * 32 + localDate.getMonthOfYear() * 32 + localDate.getDayOfMonth();
        output.writeInt(packedYearMonthDay, true);
        String chronologyId = IdentifiableChronology.getChronologyId(localDate.getChronology());
        output.writeString(chronologyId == null ? "" : chronologyId);
    }
}

