/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.actors.initializer;

import com.typesafe.config.Config;
import com.xebialabs.xlrelease.actors.ActorServiceHolder;
import com.xebialabs.xlrelease.actors.ActorSystemHolder;
import com.xebialabs.xlrelease.actors.ManagedActor;
import com.xebialabs.xlrelease.actors.NonShardedReleasesActor$;
import com.xebialabs.xlrelease.actors.ReleaseActor;
import com.xebialabs.xlrelease.actors.ReleaseActor$;
import com.xebialabs.xlrelease.actors.ReleaseExecutionActor$;
import com.xebialabs.xlrelease.actors.ReleaseReadFailureActor$;
import com.xebialabs.xlrelease.actors.ReleaseSupervisorActor$;
import com.xebialabs.xlrelease.actors.package$;
import com.xebialabs.xlrelease.actors.sharding.ReleaseShardingMessages;
import com.xebialabs.xlrelease.actors.sharding.ReleaseShardingMessages$PrepareForBalance$;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import java.io.Serializable;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefFactory;
import org.apache.pekko.actor.Props;
import org.apache.pekko.cluster.sharding.ShardRegion;
import org.apache.pekko.event.LoggingAdapter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Configuration
@ScalaSignature(bytes="\u0006\u0005q3AAB\u0004\u0001%!A\u0011\u0004\u0001B\u0001B\u0003%!\u0004\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u0011!)\u0003A!A!\u0002\u00131\u0003\"B\u0015\u0001\t\u0003Q\u0003\"\u0002\u0019\u0001\t\u0003\t$a\u0006*fY\u0016\f7/Z!di>\u0014\u0018J\\5uS\u0006d\u0017N_3s\u0015\tA\u0011\"A\u0006j]&$\u0018.\u00197ju\u0016\u0014(B\u0001\u0006\f\u0003\u0019\t7\r^8sg*\u0011A\"D\u0001\nq2\u0014X\r\\3bg\u0016T!AD\b\u0002\u0013a,'-[1mC\n\u001c(\"\u0001\t\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g-A\u0005yYJ\u001cuN\u001c4jOB\u00111DH\u0007\u00029)\u0011QdC\u0001\u0007G>tg-[4\n\u0005}a\"!\u0003-me\u000e{gNZ5h\u0003E\t7\r^8s'f\u001cH/Z7I_2$WM\u001d\t\u0003E\rj\u0011!C\u0005\u0003I%\u0011\u0011#Q2u_J\u001c\u0016p\u001d;f[\"{G\u000eZ3s\u0003I\t7\r^8s'\u0016\u0014h/[2f\u0011>dG-\u001a:\u0011\u0005\t:\u0013B\u0001\u0015\n\u0005I\t5\r^8s'\u0016\u0014h/[2f\u0011>dG-\u001a:\u0002\rqJg.\u001b;?)\u0011YSFL\u0018\u0011\u00051\u0002Q\"A\u0004\t\u000be!\u0001\u0019\u0001\u000e\t\u000b\u0001\"\u0001\u0019A\u0011\t\u000b\u0015\"\u0001\u0019\u0001\u0014\u0002)I,G.Z1tKNl\u0015M\\1hK\u0012\f5\r^8s+\u0005\u0011\u0004CA\u001aB\u001d\t!tH\u0004\u00026}9\u0011a'\u0010\b\u0003oqr!\u0001O\u001e\u000e\u0003eR!AO\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012B\u0001\b\u0010\u0013\taQ\"\u0003\u0002\u000b\u0017%\u0011\u0001)C\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00115I\u0001\u000bSK2,\u0017m]3t\u001b\u0006t\u0017mZ3e\u0003\u000e$xN\u001d\u0006\u0003\u0001&A#!B#\u0011\u0005\u0019{U\"A$\u000b\u0005!K\u0015AC1o]>$\u0018\r^5p]*\u0011!jS\u0001\bG>tG/\u001a=u\u0015\taU*A\btaJLgn\u001a4sC6,wo\u001c:l\u0015\u0005q\u0015aA8sO&\u0011\u0001k\u0012\u0002\u0005\u0005\u0016\fg\u000e\u000b\u0003\u0006%V3\u0006C\u0001$T\u0013\t!vIA\u0006EKN\u001c'/\u001b9uS>t\u0017!\u0002<bYV,\u0017%A,\u0002/J+G.Z1tKN\f5\r^8sA\u0011L7\u000f]1uG\",7\u000f\t;pAM,\b/\u001a:wSN|'\u000fI\u001f?A%tG-\u001b<jIV\fG\u000e\t:fY\u0016\f7/\u001a\u0011bGR|'o\u001d\u0011>}\u0001*\u00070Z2vi&|g\u000eI1di>\u00148\u000f\u000b\u0002\u00013B\u0011aIW\u0005\u00037\u001e\u0013QbQ8oM&<WO]1uS>t\u0007")
public class ReleaseActorInitializer {
    private final XlrConfig xlrConfig;
    private final ActorSystemHolder actorSystemHolder;
    private final ActorServiceHolder actorServiceHolder;

    @Bean
    @Description(value="ReleasesActor dispatches to supervisor => individual release actors => execution actors")
    public ManagedActor<ReleaseActor> releasesManagedActor() {
        Function3 & Serializable releaseActorMaker = (Function3 & Serializable)(ctx2, releaseId, log) -> {
            ReleaseStatus status = $this.actorServiceHolder.releaseService().getStatus((String)releaseId);
            if (status != null) {
                Function3 & Serializable executionActorMaker = (Function3 & Serializable)(ctx, supervisor, x$1) -> ctx.actorOf(ReleaseExecutionActor$.MODULE$.props($this.actorServiceHolder, (ActorRef)supervisor, (String)releaseId), ReleaseExecutionActor$.MODULE$.name());
                ReleaseStatus releaseStatus = status;
                ReleaseStatus releaseStatus2 = ReleaseStatus.TEMPLATE;
                return ctx2.actorOf(ReleaseActor$.MODULE$.props($this.actorServiceHolder, (Function3<ActorRefFactory, ActorRef, String, ActorRef>)executionActorMaker, (String)releaseId, !(releaseStatus != null ? !releaseStatus.equals(releaseStatus2) : releaseStatus2 != null), $this.xlrConfig), ReleaseActor$.MODULE$.name());
            }
            log.warning("Creating [" + ReleaseReadFailureActor$.MODULE$.name() + "] for [" + releaseId + "].");
            return ctx2.actorOf(ReleaseReadFailureActor$.MODULE$.props((Throwable)new LogFriendlyNotFoundException(releaseId + " not found", new Object[0])), ReleaseReadFailureActor$.MODULE$.name());
        };
        Props releaseSupervisorProps = ReleaseSupervisorActor$.MODULE$.props((Function3<ActorRefFactory, String, LoggingAdapter, ActorRef>)releaseActorMaker, this.xlrConfig);
        if (this.xlrConfig.isClusterEnabled()) {
            Serializable entityIdExtractor = new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof ReleaseShardingMessages.ReleaseAction) {
                        ReleaseShardingMessages.ReleaseAction releaseAction = (ReleaseShardingMessages.ReleaseAction)A1;
                        String id = releaseAction.releaseId();
                        Object msg = releaseAction.payload();
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.releaseId2ActorName(id)), msg);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    return object instanceof ReleaseShardingMessages.ReleaseAction;
                }
            };
            Function1 & Serializable shardResolver = (Function1 & Serializable)numberOfShards -> ReleaseActorInitializer.$anonfun$releasesManagedActor$3(BoxesRunTime.unboxToInt((Object)numberOfShards));
            Props x$1 = releaseSupervisorProps;
            String x$2 = "release";
            Serializable x$3 = entityIdExtractor;
            Function1 x$4 = (Function1)shardResolver.apply((Object)BoxesRunTime.boxToInteger((int)this.xlrConfig.sharding().numberOfReleaseShards()));
            ReleaseShardingMessages$PrepareForBalance$ x$5 = ReleaseShardingMessages$PrepareForBalance$.MODULE$;
            Option<Config> x$6 = this.actorSystemHolder.shardedActorOf$default$5();
            return this.actorSystemHolder.shardedActorOf(x$1, "release", (PartialFunction<Object, Tuple2<String, Object>>)x$3, (Function1<Object, String>)x$4, x$6, x$5);
        }
        return this.actorSystemHolder.actorOf(NonShardedReleasesActor$.MODULE$.props(releaseSupervisorProps, this.xlrConfig), NonShardedReleasesActor$.MODULE$.name());
    }

    private static final String releaseIdToShardId$1(String releaseId, int numberOfShards) {
        return Integer.toString(Math.abs(package$.MODULE$.releaseId2ActorName(releaseId).hashCode()) % numberOfShards);
    }

    public static final /* synthetic */ Function1 $anonfun$releasesManagedActor$3(int numberOfShards) {
        return (Function1 & Serializable)x0$1 -> {
            Object object = x0$1;
            if (object instanceof ReleaseShardingMessages.ReleaseAction) {
                ReleaseShardingMessages.ReleaseAction releaseAction = (ReleaseShardingMessages.ReleaseAction)object;
                String id = releaseAction.releaseId();
                return ReleaseActorInitializer.releaseIdToShardId$1(id, numberOfShards);
            }
            if (object instanceof ShardRegion.StartEntity) {
                ShardRegion.StartEntity startEntity = (ShardRegion.StartEntity)object;
                String id = startEntity.entityId();
                return ReleaseActorInitializer.releaseIdToShardId$1(id, numberOfShards);
            }
            throw new MatchError(object);
        };
    }

    public ReleaseActorInitializer(XlrConfig xlrConfig, ActorSystemHolder actorSystemHolder, ActorServiceHolder actorServiceHolder) {
        this.xlrConfig = xlrConfig;
        this.actorSystemHolder = actorSystemHolder;
        this.actorServiceHolder = actorServiceHolder;
    }
}

