package com.xebialabs.xlrelease.views;

import java.util.List;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

import static com.google.common.collect.Lists.newArrayList;

public class ReleaseDependenciesView {

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String releaseId;

    private List<DependencyNode> incomingDependencies = newArrayList();
    private List<DependencyNode> outgoingDependencies = newArrayList();

    public ReleaseDependenciesView(String releaseId, List<DependencyNode> incomingDependencies, List<DependencyNode> outgoingDependencies) {
        this.releaseId = releaseId;
        this.incomingDependencies = incomingDependencies;
        this.outgoingDependencies = outgoingDependencies;
    }

    public String getReleaseId() {
        return releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public List<DependencyNode> getIncomingDependencies() {
        return incomingDependencies;
    }

    public void setIncomingDependencies(List<DependencyNode> incomingDependencies) {
        this.incomingDependencies = incomingDependencies;
    }

    public List<DependencyNode> getOutgoingDependencies() {
        return outgoingDependencies;
    }

    public void setOutgoingDependencies(List<DependencyNode> outgoingDependencies) {
        this.outgoingDependencies = outgoingDependencies;
    }

}
