package com.xebialabs.xlrelease.views;

import java.util.Date;
import java.util.List;
import java.util.Objects;

import static java.util.Collections.emptyList;

public class LogsFilters {

    public static final LogsFilters ALL = all();

    private String filter;
    private Date from;
    private Date to;
    private boolean releaseEdit;
    private boolean taskEdit;
    private boolean triggerEdit;
    private boolean deliveryEdit;
    private boolean comments;
    private boolean lifecycle;
    private boolean reassign;
    private boolean reportingRecordEdit;
    private boolean security;
    private boolean dateAsc;
    private boolean execution;
    private boolean other;
    private String targetId;
    private List<String> activityTypes = emptyList();
    private List<String> usernames = emptyList();

    public LogsFilters() {
    }

    public static LogsFilters all() {
        LogsFilters filter = new LogsFilters();
        filter.setReleaseEdit(true);
        filter.setTaskEdit(true);
        filter.setTriggerEdit(true);
        filter.setDeliveryEdit(true);
        filter.setComments(true);
        filter.setLifecycle(true);
        filter.setReassign(true);
        filter.setReportingRecordEdit(true);
        filter.setSecurity(true);
        filter.setExecution(true);
        filter.setOther(true);
        return filter;
    }

    public String getFilter() {
        return filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Date getFrom() {
        return from;
    }

    public void setFrom(Date from) {
        this.from = from;
    }

    public Date getTo() {
        return to;
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public boolean withReleaseEdit() {
        return releaseEdit;
    }

    public void setReleaseEdit(boolean releaseEdit) {
        this.releaseEdit = releaseEdit;
    }

    public boolean withTaskEdit() {
        return taskEdit;
    }

    public void setTaskEdit(boolean taskEdit) {
        this.taskEdit = taskEdit;
    }

    public boolean withTriggerEdit() {
        return triggerEdit;
    }

    public void setTriggerEdit(boolean triggerEdit) {
        this.triggerEdit = triggerEdit;
    }

    public boolean withDeliveryEdit() {
        return deliveryEdit;
    }

    public void setDeliveryEdit(boolean deliveryEdit) {
        this.deliveryEdit = deliveryEdit;
    }

    public boolean withComments() {
        return comments;
    }

    public void setComments(boolean comments) {
        this.comments = comments;
    }

    public boolean withLifecycle() {
        return lifecycle;
    }

    public void setLifecycle(boolean lifecycle) {
        this.lifecycle = lifecycle;
    }

    public boolean withReassign() {
        return reassign;
    }

    public void setReassign(boolean reassign) {
        this.reassign = reassign;
    }

    public boolean withReportingRecordEdit() {
        return reportingRecordEdit;
    }

    public void setReportingRecordEdit(boolean reportingRecordEdit) {
        this.reportingRecordEdit = reportingRecordEdit;
    }

    public boolean withSecurity() {
        return security;
    }

    public void setSecurity(boolean security) {
        this.security = security;
    }

    public boolean isDateAsc() {
        return dateAsc;
    }

    public void setDateAsc(final boolean dateAsc) {
        this.dateAsc = dateAsc;
    }

    public boolean withExecution() {
        return execution;
    }

    public void setExecution(boolean execution) {
        this.execution = execution;
    }

    public void setOther(boolean other) {
        this.other = other;
    }

    public boolean withOther() {
        return other;
    }

    public void setTargetId(final String targetId) {
        this.targetId = targetId;
    }

    public String getTargetId() {
        return targetId;
    }

    public List<String> getActivityTypes() {
        return activityTypes;
    }

    public void setActivityTypes(List<String> activityTypes) {
        this.activityTypes = activityTypes;
    }

    public List<String> getUsernames() {
        return usernames;
    }

    public void setUsernames(List<String> usernames) {
        this.usernames = usernames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        LogsFilters that = (LogsFilters) o;
        return releaseEdit == that.releaseEdit && taskEdit == that.taskEdit && triggerEdit == that.triggerEdit && deliveryEdit == that.deliveryEdit && comments == that.comments && lifecycle == that.lifecycle && reassign == that.reassign && reportingRecordEdit == that.reportingRecordEdit && security == that.security && dateAsc == that.dateAsc && execution == that.execution && other == that.other && Objects.equals(filter, that.filter) && Objects.equals(from, that.from) && Objects.equals(to, that.to) && Objects.equals(targetId, that.targetId) && Objects.equals(activityTypes, that.activityTypes) && Objects.equals(usernames, that.usernames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(filter, from, to, releaseEdit, taskEdit, triggerEdit, deliveryEdit, comments, lifecycle, reassign, reportingRecordEdit, security, dateAsc, execution, other, targetId, activityTypes, usernames);
    }
}
