package com.xebialabs.xlrelease.upgrade

import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry.getDescriptor
import com.xebialabs.deployit.plugin.api.reflect.{Descriptor, Type}
import com.xebialabs.deployit.server.api.upgrade.Version
import com.xebialabs.xlrelease.configuration.SystemMessageSettings
import com.xebialabs.xlrelease.repository.ConfigurationRepository
import com.xebialabs.xlrelease.upgrade.Components.XL_RELEASE_COMPONENT
import com.xebialabs.xlrelease.upgrade.common.{BaseInitializingUpgrade, ClassNameToString}
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired

class SystemMessageInitializer @Autowired()(configurationRepository: ConfigurationRepository)
  extends BaseInitializingUpgrade with Logging with ClassNameToString {

  override def doUpgrade(): Boolean = {
    logger.debug("Initializing default system message")
    val descriptor: Descriptor = getDescriptor(Type.valueOf(classOf[SystemMessageSettings]))
    val ci: SystemMessageSettings = descriptor.newInstance(SystemMessageSettings.SYSTEM_MESSAGE_ID)
    logger.debug(s"Creating CI: ${SystemMessageSettings.SYSTEM_MESSAGE_ID}")
    configurationRepository.create(ci)
    true
  }

  override def upgradeVersion(): Version = Version.valueOf(XL_RELEASE_COMPONENT, "8.6.0#1")

}
