package com.xebialabs.xlrelease.script.groovy

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.spring.configuration.ExecutorNames.{AUXILIARY_EXECUTOR_NAME, POLLING_EXECUTOR_NAME, TIMEOUT_EXECUTOR_NAME}
import com.xebialabs.xlrelease.script.{DefaultScriptService, ScriptLifeCycle, ScriptService, ScriptVariables}
import com.xebialabs.xlrelease.security.PermissionChecker
import com.xebialabs.xlrelease.security.authentication.AuthenticationService
import com.xebialabs.xlrelease.service._
import org.apache.commons.io.FilenameUtils
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.stereotype.Component

import java.util.concurrent.ScheduledExecutorService

@Component
class GroovyScriptService(scriptLifeCycle: ScriptLifeCycle,
                          groovyScriptExecutor: GroovyScriptExecutor,
                          authenticationService: AuthenticationService,
                          releaseService: ReleaseService,
                          scriptVariables: ScriptVariables,
                          permissions: PermissionChecker,
                          commentService: CommentService,
                          xlrConfig: XlrConfig,
                          attachmentService: AttachmentService,
                          configurationVariableService: ConfigurationVariableService,
                          configurationService: ConfigurationService,
                          @Qualifier(TIMEOUT_EXECUTOR_NAME) timeoutExecutor: ScheduledExecutorService,
                          @Qualifier(AUXILIARY_EXECUTOR_NAME) auxiliaryExecutor: ScheduledExecutorService,
                          @Qualifier(POLLING_EXECUTOR_NAME) pollingExecutor: ScheduledExecutorService
                         )
  extends DefaultScriptService(
    scriptLifeCycle,
    groovyScriptExecutor,
    authenticationService,
    releaseService,
    scriptVariables,
    permissions,
    commentService,
    xlrConfig,
    attachmentService,
    configurationVariableService,
    configurationService,
    timeoutExecutor,
    auxiliaryExecutor,
    pollingExecutor
  ) with ScriptService {

  override def engine: String = "groovy"

  override def accepts(filename: String): Boolean = {
    "groovy" == FilenameUtils.getExtension(filename)
  }
}
