package com.xebialabs.xlrelease.script.el

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.script.{PreconditionService, ScriptVariables}
import com.xebialabs.xlrelease.security.authentication.AuthenticationService
import com.xebialabs.xlrelease.service.CommentService
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.expression.{ExpressionParser, MethodResolver}

@Configuration
class ElScriptingConfiguration(xlrConfig: XlrConfig,
                               scriptVariables: ScriptVariables,
                               authenticationService: AuthenticationService,
                               commentService: CommentService) {

  @Bean
  def methodAccessCheck: MethodAccessCheck = {
    val restrictedMethodMap = xlrConfig.security.el.restrictedMethods
    new ElMethodAccessCheck(restrictedMethods = restrictedMethodMap)
  }

  @Bean
  def methodResolver: MethodResolver = new ElMethodResolver(methodAccessCheck)

  @Bean
  def contextBuilder: EvaluationContextBuilder = new EvaluationContextBuilder(scriptVariables, methodResolver)

  @Bean
  def secureExpressionParser: ExpressionParser = new ElSecureExpressionParser()

  @Bean
  def elPreconditionService: PreconditionService = new ElPreconditionService(authenticationService, commentService, secureExpressionParser, contextBuilder)

}
