package com.xebialabs.xlrelease.script.el

import com.xebialabs.xlrelease.script.el.MethodAccessCheck.{AccessAllowed, AccessDenied}

import java.util.regex.Pattern

class ElMethodAccessCheck(restrictedMethods: Map[String, List[String]]) extends MethodAccessCheck {
  // Load restricted methods from configuration
  private val restrictions: Map[Pattern, List[Pattern]] = {
    restrictedMethods.map { case (className, methods) =>
      Pattern.compile(className) -> methods.map(Pattern.compile)
    }
  }

  override def checkAccess(targetClassName: String, methodName: String): MethodAccessCheck.AccessCheckResult = {
    val matchedMethodPatters = restrictions.filter {
      case (classPattern, _) => classPattern.matcher(targetClassName).matches()
    }.values.flatten
    val blocked = matchedMethodPatters.exists(_.matcher(methodName).matches())
    if (blocked) {
      AccessDenied(s"Method '$methodName' is not permitted on type '$targetClassName'")
    } else {
      AccessAllowed
    }
  }

}
