package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.ReleaseService;

public interface TaskSoftReferenceFactory {

    static <U extends Task> TaskSoftReference<U> taskRef(ReleaseService releaseService, U task) {
        String taskId = task.getId();
        return new TaskSoftReference<>(task, () -> getTask(releaseService, taskId));
    }

    static <U extends Task> TaskSoftReference<U> taskRef(ReleaseService releaseService, String taskId, String executionId, Integer releaseCiUid) {
        return new TaskSoftReference<>(taskId, executionId, releaseCiUid, () -> getTask(releaseService, taskId));
    }

    @SuppressWarnings("unchecked")
    private static <U extends Task> U getTask(final ReleaseService releaseService, final String taskId) {
        return (U) releaseService.findById(Ids.releaseIdFrom(taskId)).getTask(taskId);
    }
}
