package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.Tenant
import com.xebialabs.xlrelease.domain.status.TenantStatus

trait TenantRepository {

  def findById(tenantId: String): Option[Tenant]

  def findByName(name: String): Option[Tenant]

  def findAll(): Seq[Tenant]

  def create(tenantName: String, tenantStatus: TenantStatus): Tenant

  def update(tenant: Tenant): Unit

  def delete(tenantId: String): Unit

  def linkFoldersToTenant(tenantId: String, folderIds: List[String]): Unit

  def linkUserProfilesToTenant(tenantId: String, userProfileIds: List[String]): Unit
}
