package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.Team
import com.xebialabs.xlrelease.repository.TeamRepository._
import com.xebialabs.xlrelease.security.SecuredCi

import java.util.{List => JList}

trait TeamRepository {
  def getTeams(containerId: String): JList[Team]

  def getTeams(container: SecuredCi): JList[Team]

  def create(containerId: String, team: Team): Team

  def delete(teamId: String): Unit

  def update(teamToUpdate: Team): Team

  def saveTeamsToPlatform(containerId: String, teams: JList[Team]): JList[Team]

  def deleteTeamsFromPlatform(containerId: String): Unit

  def deleteTeamsFromPlatform(container: SecuredCi): Unit

  def getTeamPermissionRows(container: SecuredCi): Seq[TeamPermissionRow]

  def getMembersPerTeam(container: SecuredCi): Seq[TeamMemberRow]

}

object TeamRepository {

  case class TeamRow(teamId: String, teamName: String)

  case class TeamMemberRow(team: TeamRow, member: Option[MemberRow])

  case class MemberRow(name: String, fullName: String, roleId: String)

  case class TeamPermissionRow(teamInfo: TeamRow, permissionName: String)

}