package com.xebialabs.xlrelease.repository

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.calendar.CalendarEntry
import com.xebialabs.xlrelease.repository.Ids.isNullId

import java.util
import java.util.Date

trait CalendarEntryRepository {

  def create(calendarEntry: CalendarEntry): Unit

  def update(calendarEntry: CalendarEntry): Unit

  def createOrUpdate(calendarEntry: CalendarEntry): Unit = {
    if (!isNullId(calendarEntry.getId) && exists(calendarEntry.getId)) {
      update(calendarEntry)
    } else {
      create(calendarEntry)
    }
  }

  def delete(id: String): Unit

  def exists(id: String): Boolean

  def findById[T <: CalendarEntry](id: String): T

  def findAllByType[T <: CalendarEntry](ciType: Type): util.List[T]

  def findAllByTypeInRange[T <: CalendarEntry](ciType: Type, from: Date, to: Date): util.List[T]

  def existsByTypeInRange(ciType: Type, from: Date, to: Date): Boolean
}
