package com.xebialabs.xlrelease.health;

import org.springframework.boot.actuate.availability.ReadinessStateHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.boot.availability.ApplicationAvailability;

import com.xebialabs.xlrelease.service.XlrServiceManager;

public class XlrReadinessStateHealthIndicator extends ReadinessStateHealthIndicator {

    private final XlrServiceManager serviceManager;

    public XlrReadinessStateHealthIndicator(ApplicationAvailability availability,
                                            XlrServiceManager serviceManager) {
        super(availability);
        this.serviceManager = serviceManager;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Status xlrStatus = serviceManager.getHealthStatus();
        if (xlrStatus != Status.UP) {
            builder.status(xlrStatus);
        } else {
            super.doHealthCheck(builder);
        }
    }
}
