package com.xebialabs.xlrelease.api.internal;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.security.IdentityProvider;
import com.xebialabs.xlrelease.views.AuthenticationView;

@Path("/auth")
@Consumes({MediaType.APPLICATION_JSON})
@Produces({MediaType.APPLICATION_JSON})
@Controller
public class AuthenticationResource {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationResource.class);

    // Identity Provider that is registered in the Spring ApplicationContext.
    @Autowired(required=false)
    private IdentityProvider identityProvider;

    /**
     * Provides registered identity provider and if a user is logged in.
     * @return AuthenticationView
     */
    @GET
    public AuthenticationView getAuthenticationView() {
        String userName = Permissions.getAuthenticatedUserName();
        logger.info("Logged in user {} with identity provider {}", userName, identityProvider);

        return new AuthenticationView(userName, identityProvider);
    }
}
