package com.xebialabs.xlrelease.actors

import com.xebialabs.xlrelease.actors.ReleaseSupervisorActor.{GcRequest, GracefulPoisonPill, ReleasePoisonPill}
import org.apache.pekko.actor.Status.Failure
import org.apache.pekko.actor.{Actor, ActorLogging, Props}

object ReleaseReadFailureActor {

  val name = "release-read-failure-actor"

  def props(ex: Throwable): Props = Props(new ReleaseReadFailureActor(ex)).withDispatcher("xl.dispatchers.release-dispatcher")
}

/**
  * This actor is created instead of [[ReleaseActor]] when requested release could not be read from the repository.
  */
class ReleaseReadFailureActor(ex: Throwable) extends Actor with ActorLogging with ExceptionTranslateActor {

  override def receive: Receive = {
    case GcRequest =>
      sender() ! ReleasePoisonPill
    case Failure(_) =>
      context.parent ! ReleasePoisonPill
    case GracefulPoisonPill =>
      context.stop(self)
    case msg =>
      log.warning(s"Message $msg accessed release which could not be read from the repository due to: ${ex.getMessage}")
      if (self != sender()) {
        sender() ! Failure(translate(ex))
      }
      context.parent ! ReleasePoisonPill
  }

}
