package com.xebialabs.xlrelease.health

import org.springframework.boot.actuate.endpoint.web.WebServerNamespace
import org.springframework.boot.actuate.endpoint.{ApiVersion, SecurityContext}
import org.springframework.boot.actuate.health.{HealthEndpointWebExtension, Status}
import org.springframework.stereotype.Controller

import jakarta.ws.rs._
import jakarta.ws.rs.core.{MediaType, Response}

@Path("/ha/health")
@Controller
class HealthCheck(health: HealthEndpointWebExtension) {

  @HEAD
  @GET
  @Produces(Array(MediaType.APPLICATION_JSON))
  def health(): Response = {
    val healthCheck = health.health(ApiVersion.V3, WebServerNamespace.SERVER, SecurityContext.NONE)
    if (healthCheck.getStatus == 200 && healthCheck.getBody.getStatus == Status.UP) {
      Response.ok("{ \"status\": \"OK\" }").build()
    } else {
      Response.status(404).entity("I'm not here, see my friend").build()
    }
  }
}
