/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.limits;

import com.xebialabs.xlrelease.configuration.TenantLimit;
import com.xebialabs.xlrelease.exception.RateLimitReachedException;
import com.xebialabs.xlrelease.repository.TenantLimitRepository;
import java.util.function.IntSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LimitEnforcer {
    private static final Logger logger = LoggerFactory.getLogger(LimitEnforcer.class);
    private final TenantLimitRepository tenantLimitRepository;

    public LimitEnforcer(TenantLimitRepository tenantLimitRepository) {
        this.tenantLimitRepository = tenantLimitRepository;
    }

    public void enforceLimit(String tenantId, LimitType limitType, int increment, IntSupplier currentCountSupplier) {
        TenantLimit tenantLimit = this.tenantLimitRepository.getEffectiveLimit(tenantId);
        if (!tenantLimit.isEnabled()) {
            logger.debug("Limit enforcement is disabled for tenant: {}", (Object)tenantId);
            return;
        }
        int limit = this.getConfiguredLimit(limitType, tenantLimit);
        if (limit < 0) {
            logger.debug("Unlimited {} allowed for tenant: {}", (Object)limitType.getResourceName(), (Object)tenantId);
            return;
        }
        int currentCount = currentCountSupplier.getAsInt();
        if (currentCount + increment > limit) {
            String message = this.buildLimitExceededMessage(limitType, currentCount, limit);
            throw new RateLimitReachedException(message);
        }
        logger.debug("Limit enforcement passed for tenant {}: {} {}/{} after increment of {}", new Object[]{tenantId, limitType.getResourceName(), currentCount, limit, increment});
    }

    private int getConfiguredLimit(LimitType limitType, TenantLimit tenantLimit) {
        return switch (limitType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> tenantLimit.getMaxFolders();
            case 1 -> tenantLimit.getMaxConnections();
            case 2 -> tenantLimit.getMaxTemplates();
            case 3 -> tenantLimit.getMaxRunningReleases();
            case 4 -> tenantLimit.getMaxWorkflowTemplates();
            case 5 -> tenantLimit.getMaxWorkflowExecutions();
            case 6 -> tenantLimit.getMaxTriggers();
            case 7 -> tenantLimit.getMaxPatterns();
            case 8 -> tenantLimit.getMaxDeliveries();
        };
    }

    private String buildLimitExceededMessage(LimitType limitType, int actual, int limit) {
        return String.format("%s limit reached (%d of %d used). You cannot add more %s.", limitType.getDisplayName(), actual, limit, limitType.getDisplayName().toLowerCase());
    }

    public static enum LimitType {
        FOLDERS("Folders", "folders"),
        CONNECTIONS("Connections", "connections"),
        TEMPLATES("Templates", "templates"),
        RELEASES("Running releases", "running releases"),
        WORKFLOW_TEMPLATES("Workflow templates", "workflow templates"),
        WORKFLOW_EXECUTIONS("Workflow executions", "workflow executions"),
        TRIGGERS("Triggers", "triggers"),
        PATTERNS("Patterns", "patterns"),
        DELIVERIES("Deliveries", "deliveries");

        private final String displayName;
        private final String resourceName;

        private LimitType(String displayName, String resourceName) {
            this.displayName = displayName;
            this.resourceName = resourceName;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getResourceName() {
            return this.resourceName;
        }
    }
}

