/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.xebialabs.deployit.ReleaseInfo;
import com.xebialabs.deployit.ServerConfigFile;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.util.DeployitKeyStoreException;
import com.xebialabs.deployit.util.DeployitKeys;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.XLReleaseBootstrapper;
import com.xebialabs.xlrelease.XLReleaseServerLaunchOptions;
import com.xebialabs.xlrelease.XLReleaseSetup;
import java.lang.management.ManagementFactory;
import java.time.Year;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.crypto.SecretKey;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReleaseServer {
    private static final int DEFAULT_PORT = 5516;
    private static final Logger logger = LoggerFactory.getLogger(ReleaseServer.class);
    private static final String PRODUCT_RELEASE = XLReleaseBootstrapper.PRODUCT_DIGITALAI();
    private final XLReleaseServerLaunchOptions launchOptions;
    private final ServerConfigFile configFile;
    private boolean isConfigAndPasswordInitDone = false;
    private static final List<String> ADD_OPENS = List.of("--add-opens=java.base/sun.net.www.protocol.jar=ALL-UNNAMED", "--add-opens=java.base/java.security=ALL-UNNAMED", "--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/java.util=ALL-UNNAMED", "--add-opens=java.base/java.util.concurrent.locks=ALL-UNNAMED", "--add-opens=java.base/java.util.regex=ALL-UNNAMED", "--add-opens=java.base/java.lang.invoke=ALL-UNNAMED", "--add-opens=java.base/jdk.internal.misc=ALL-UNNAMED", "--add-opens=java.base/java.io=ALL-UNNAMED");

    public ReleaseServer(XLReleaseServerLaunchOptions launchOptions, ServerConfigFile configFile) {
        this.launchOptions = launchOptions;
        this.configFile = configFile;
    }

    public static void outputReleaseInfo() {
        ReleaseInfo releaseInfo = new ReleaseInfo("com/xebialabs/deployit/release.properties");
        logger.info("{} version {} (built at {})", new Object[]{PRODUCT_RELEASE, releaseInfo.getVersion(), releaseInfo.getDate()});
        logger.info("{} running with {} (version {}) from {}", new Object[]{PRODUCT_RELEASE, System.getProperty("java.runtime.name"), System.getProperty("java.runtime.version"), System.getProperty("java.vm.vendor")});
        logger.info("(c) 2012-{} Digital.ai.", (Object)Year.now().getValue());
        if (Environment.isDevelopment()) {
            logger.warn(" DEVELOPMENT MODE");
        }
    }

    public void prepareConfigs() {
        if (this.launchOptions.isDoSetup()) {
            this.startSetup();
            System.exit(0);
        } else {
            if (!this.configFile.exists()) {
                logger.warn("Configuration not found...");
                this.startSetup();
            }
            if (!this.isConfigAndPasswordInitDone) {
                this.loadConfigAndInitPasswordEncryptionKey();
            }
        }
    }

    public static void verifyAddOpens() {
        List<String> argsList = ManagementFactory.getRuntimeMXBean().getInputArguments();
        Set missing = ADD_OPENS.stream().filter(required -> !argsList.contains(required)).collect(Collectors.toSet());
        if (!missing.isEmpty()) {
            String missingFormated = String.join((CharSequence)"\n", missing);
            String osName = SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX ? "linux" : "win";
            String errorMessage = "The following Add-Opens VM options are missing \n\n" + missingFormated + "\n\nPlease add them to the xlr-wrapper-" + osName + ".conf, in the wrapper.java.additional parameters section";
            logger.error(errorMessage);
            System.exit(0);
        }
    }

    private void startSetup() {
        ServerConfiguration serverDefaults = new ServerConfiguration();
        serverDefaults.setHttpPort(5516);
        logger.info("Initializing Repository");
        XLReleaseSetup setupWizard = new XLReleaseSetup(PRODUCT_RELEASE, this.configFile, this.launchOptions, serverDefaults);
        setupWizard.run();
    }

    private void loadConfigAndInitPasswordEncryptionKey() {
        ServerConfiguration config = this.configFile.loadConfig(false, false);
        String repositoryKeyStorePassword = this.launchOptions.getRepositoryKeystorePassword() != null ? this.launchOptions.getRepositoryKeystorePassword() : config.getRepositoryKeyStorePassword();
        try {
            SecretKey passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey((String)repositoryKeyStorePassword);
            PasswordEncrypter.init((SecretKey)passwordEncryptionKey);
        }
        catch (DeployitKeyStoreException e) {
            throw new RuntimeException("Could not load the encryption key. The server will not start.");
        }
        config.loadEncryptedPasswords();
        this.configFile.saveDirtyConfiguration(config);
        ServerConfiguration.setInstance((ServerConfiguration)config);
        XLReleaseServerLaunchOptions.setInstance(this.launchOptions);
        this.isConfigAndPasswordInitDone = true;
    }
}

