package com.xebialabs.xlrelease.service.blackout

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem
import com.xebialabs.xlrelease.api.internal.{CachedInternalMetadataDecorator, DecoratorCache}
import com.xebialabs.xlrelease.domain.Release
import com.xebialabs.xlrelease.domain.blackout.BlackoutMetadata.BLACKOUT
import com.xebialabs.xlrelease.domain.blackout.{BlackoutMetadata, BlackoutPeriod}
import com.xebialabs.xlrelease.service.CalendarService
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import java.util
import java.util.Date
import scala.jdk.CollectionConverters._

@Component
class BlackoutMetadataDecorator @Autowired()(calendarService: CalendarService) extends CachedInternalMetadataDecorator[Release, BlackoutMetadata] {

  override def isApplicableTo(ci: ConfigurationItem): Boolean = ci.isInstanceOf[Release]

  override val name: String = BLACKOUT

  override def decorate(cis: util.Collection[Release], cache: DecoratorCache[BlackoutMetadata]): Unit = {
    val metadata = cache.computeIfAbsent(() => BlackoutMetadata(calendarService
      .getBlackouts(new Date())
      .asScala
      .map(blackout => BlackoutPeriod(blackout.getStartDate, blackout.getEndDate))
      .toSeq))
    cis.asScala.foreach(_.get$metadata().put(BLACKOUT, metadata))
  }

}

