package com.xebialabs.xlrelease.service

import jakarta.ws.rs.sse.SseEventSink

trait SseService {

  def subscribeUserToSink(sink: SseEventSink): Unit

  def subscribeTopicToUser(topic: String): Unit

  def subscribeTopicToUser(topic: String, username: String): Unit

  def unsubscribeTopicToUser(topic: String): Unit

  def unsubscribeTopicToUser(topic: String, username: String): Unit

  def unsubscribeAllUsers(topic: String): Unit

  def sendEvent(topic: String, eventName: String, payload: String): Unit

  def hasActiveUsers(topic: String): Boolean = false
}
