package com.xebialabs.xlrelease.export

import com.xebialabs.xlrelease.domain.{Release, Team}
import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.service.TeamService
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

import java.util
import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Service
class TeamsInFolderRemovalImportProcessor @Autowired()(teamService: TeamService) extends TemplateImportProcessor with Logging {

  override def process(template: Release, destinationId: String): JList[String] = {
    logger.debug(s"Folders will be removed if template ${template.getId} was exported from a folder")
    val destinationIsFolder: Boolean = Option(destinationId).exists(Ids.isFolderId)
    if (Ids.isInFolder(template.getId) && !destinationIsFolder) {
      logger.info(s"Removing non-system teams from template ${template.getId}")
      val onlyRootSystemTeams = template.getTeams.asScala.filter(t => t.isReleaseAdminTeam || t.isTemplateOwnerTeam).asJava
      template.setTeams(onlyRootSystemTeams)
      template.getAllTasks.asScala.filterNot(_.getTeam == Team.RELEASE_ADMIN_TEAMNAME).foreach(t => t.setTeam(null))

      List("Teams in this template have been reset to system teams.")
    } else if (destinationIsFolder) {
      logger.info(s"Removing teams from template ${template.getId}")
      template.setTeams(new util.ArrayList())

      val effectiveTeamNames = teamService.getEffectiveTeams(destinationId).asScala.map(_.getTeamName).toSet

      template.getAllTasks.asScala
        .filterNot(t => effectiveTeamNames.contains(t.getTeam))
        .foreach(_.setTeam(null))

      List("Teams in this template have been removed. They will be inherited from the folder.")
    } else {
      List()
    }
  }.asJava
}
