/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.plugin.api.reflect.InputHint;
import com.xebialabs.deployit.plugin.api.reflect.InputHintValue;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plumbing.PropertyDescriptorJsonWriterHelper;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Provider
@Produces(value={"application/json"})
public class PropertyDescriptorJsonWriter
implements MessageBodyWriter<PropertyDescriptor> {
    private static final Logger logger = LoggerFactory.getLogger(PropertyDescriptorJsonWriter.class);

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(PropertyDescriptor propertyDescriptor, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(PropertyDescriptor propertyDescriptor, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(propertyDescriptor).getBytes(StandardCharsets.UTF_8));
    }

    @VisibleForTesting
    String toJson(PropertyDescriptor propertyDescriptor) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        PropertyDescriptorJsonWriter.writePropertyDescriptor(writer, propertyDescriptor);
        return stringWriter.toString();
    }

    static void writePropertyDescriptor(JsonWriter writer, PropertyDescriptor propertyDescriptor) {
        List<Annotation> annotations;
        writer.object();
        writer.key("name").value((Object)propertyDescriptor.getName());
        writer.key("fqn").value((Object)propertyDescriptor.getFqn());
        writer.key("label").value((Object)propertyDescriptor.getLabel());
        writer.key("kind").value((Object)propertyDescriptor.getKind().name());
        writer.key("description").value((Object)propertyDescriptor.getDescription());
        writer.key("category").value((Object)propertyDescriptor.getCategory());
        writer.key("nested").value(propertyDescriptor.isNested());
        writer.key("order").value((long)propertyDescriptor.getOrder());
        writer.key("asContainment").value(propertyDescriptor.isAsContainment());
        writer.key("inspection").value(propertyDescriptor.isInspectionProperty());
        writer.key("required").value(propertyDescriptor.isRequired());
        writer.key("requiredInspection").value(propertyDescriptor.isRequiredForInspection());
        writer.key("password").value(propertyDescriptor.isPassword());
        writer.key("transient").value(propertyDescriptor.isTransient());
        writer.key("readonly").value(propertyDescriptor.isReadonly());
        writer.key("size").value((Object)propertyDescriptor.getSize().name());
        writer.key("referencedType").value((Object)propertyDescriptor.getReferencedType());
        Object object = propertyDescriptor.getDefaultValue();
        if (object instanceof Map) {
            Map defaultValuesMap = (Map)object;
            try {
                writer.key("default").value((Object)new JSONObject(defaultValuesMap));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        } else {
            writer.key("default").value(propertyDescriptor.getDefaultValue());
        }
        if (!CollectionUtils.isEmpty((Collection)propertyDescriptor.getEnumValues())) {
            writer.key("enumValues");
            writer.array();
            for (String enumValue : propertyDescriptor.getEnumValues()) {
                writer.value((Object)enumValue);
            }
            writer.endArray();
        }
        if (propertyDescriptor.isHidden()) {
            writer.key("hidden").value(true);
        }
        if (!(annotations = PropertyDescriptorJsonWriterHelper.getAllDescriptorAnnotations(propertyDescriptor)).isEmpty()) {
            writer.key("annotations");
            writer.object();
            annotations.forEach(annotation -> {
                writer.key(annotation.annotationType().getSimpleName());
                writer.object();
                Arrays.stream(annotation.annotationType().getDeclaredMethods()).forEach(method -> {
                    try {
                        Object value = method.invoke(annotation, (Object[])null);
                        if (value instanceof String && ((String)value).isEmpty()) {
                            writer.key(method.getName()).value(null);
                        } else {
                            writer.key(method.getName()).value(value);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException ex) {
                        logger.error("Error occurred while trying to serialize annotation", (Throwable)ex);
                    }
                });
                writer.endObject();
            });
            writer.endObject();
        }
        if (propertyDescriptor.getInputHint() != null) {
            InputHint hint = propertyDescriptor.getInputHint();
            writer.key("inputHint");
            writer.object();
            if (hint.getReferencedType() != null) {
                writer.key("referencedType").value((Object)hint.getReferencedType().getName());
            }
            if (hint.getMethodRef() != null) {
                writer.key("method-ref").value((Object)hint.getMethodRef());
            }
            writer.key("dynamic-lookup").value(hint.isDynamicLookup());
            writer.key("values");
            writer.array();
            for (InputHintValue inputHintValue : propertyDescriptor.getInputHint().getValues()) {
                writer.object();
                writer.key("label").value((Object)inputHintValue.getLabel());
                writer.key("value").value((Object)inputHintValue.getValue());
                writer.endObject();
            }
            writer.endArray();
            writer.endObject();
        }
        writer.endObject();
    }
}

