/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.xlplatform.sugar.PathSugar$;
import com.xebialabs.xlrelease.domain.TemplateLogo;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.TemplateMetadataRepository;
import com.xebialabs.xlrelease.service.WorkdirSupport;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.slf4j.Marker;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.util.FileSystemUtils;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.util.Try;
import scala.util.Using;

@Service
@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001\u0002\u0007\u000e\u0001YA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\u0006a\u0001!\t!\r\u0005\bi\u0001\u0011\r\u0011\"\u00036\u0011\u0019\u0001\u0005\u0001)A\u0005m!9\u0011\t\u0001b\u0001\n\u0013)\u0004B\u0002\"\u0001A\u0003%a\u0007C\u0003D\u0001\u0011\u0005A\tC\u0003Y\u0001\u0011%\u0011\fC\u0003c\u0001\u0011%1\rC\u0003j\u0001\u0011%!\u000eC\u0003l\u0001\u0011\u0005ANA\fUK6\u0004H.\u0019;f\u001b\u0016$\u0018\rZ1uCN+'O^5dK*\u0011abD\u0001\bg\u0016\u0014h/[2f\u0015\t\u0001\u0012#A\u0005yYJ,G.Z1tK*\u0011!cE\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001F\u0001\u0004G>l7\u0001A\n\u0005\u0001]iR\u0005\u0005\u0002\u001975\t\u0011DC\u0001\u001b\u0003\u0015\u00198-\u00197b\u0013\ta\u0012D\u0001\u0004B]f\u0014VM\u001a\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\nQa\u001d7gi)T\u0011AI\u0001\tOJL'P\u001f7fI&\u0011Ae\b\u0002\b\u0019><w-\u001b8h!\t1s%D\u0001\u000e\u0013\tASB\u0001\bX_J\\G-\u001b:TkB\u0004xN\u001d;\u00025Q,W\u000e\u001d7bi\u0016lU\r^1eCR\f'+\u001a9pg&$xN]=\u0011\u0005-rS\"\u0001\u0017\u000b\u00055z\u0011A\u0003:fa>\u001c\u0018\u000e^8ss&\u0011q\u0006\f\u0002\u001b)\u0016l\u0007\u000f\\1uK6+G/\u00193bi\u0006\u0014V\r]8tSR|'/_\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005I\u001a\u0004C\u0001\u0014\u0001\u0011\u0015I#\u00011\u0001+\u0003!\u0019\u0017m\u00195f\t&\u0014X#\u0001\u001c\u0011\u0005]rT\"\u0001\u001d\u000b\u0005eR\u0014\u0001\u00024jY\u0016T!a\u000f\u001f\u0002\u00079LwNC\u0001>\u0003\u0011Q\u0017M^1\n\u0005}B$\u0001\u0002)bi\"\f\u0011bY1dQ\u0016$\u0015N\u001d\u0011\u0002\u000f1|wm\u001c#je\u0006AAn\\4p\t&\u0014\b%A\u0004hKRdunZ8\u0015\u0005\u0015[\u0005C\u0001$J\u001b\u00059%B\u0001%=\u0003\tIw.\u0003\u0002K\u000f\n!a)\u001b7f\u0011\u0015au\u00011\u0001N\u0003\u0019awnZ8JIB\u0011a*\u0016\b\u0003\u001fN\u0003\"\u0001U\r\u000e\u0003ES!AU\u000b\u0002\rq\u0012xn\u001c;?\u0013\t!\u0016$\u0001\u0004Qe\u0016$WMZ\u0005\u0003-^\u0013aa\u0015;sS:<'B\u0001+\u001a\u0003U1W\r^2i\u0019><wN\u0012:p[\u0012\u000bG/\u00192bg\u0016$\"!\u0012.\t\u000bmC\u0001\u0019\u0001/\u0002\u0019Q,W\u000e\u001d7bi\u0016dunZ8\u0011\u0005u\u0003W\"\u00010\u000b\u0005}{\u0011A\u00023p[\u0006Lg.\u0003\u0002b=\naA+Z7qY\u0006$X\rT8h_\u0006AQ.Y6f\t&\u00148\u000f\u0006\u0002eOB\u0011\u0001$Z\u0005\u0003Mf\u0011A!\u00168ji\")\u0001.\u0003a\u0001m\u00059A-\u001b:QCRD\u0017AC2mK\u0006t7)Y2iKR\tA-A\fp]\u0006\u0003\b\u000f\\5dCRLwN\u001c*fC\u0012LXI^3oiR\u0011A-\u001c\u0005\u0006].\u0001\ra\\\u0001\u0006KZ,g\u000e\u001e\t\u0003ajl\u0011!\u001d\u0006\u0003]JT!a\u001d;\u0002\u000f\r|g\u000e^3yi*\u0011QO^\u0001\u0005E>|GO\u0003\u0002xq\u0006y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148NC\u0001z\u0003\ry'oZ\u0005\u0003wF\u0014Q#\u00119qY&\u001c\u0017\r^5p]J+\u0017\rZ=Fm\u0016tG\u000f\u000b\u0002\f{B\u0019a0a\u0001\u000e\u0003}T1A\\A\u0001\u0015\t\u0019h/C\u0002\u0002\u0006}\u0014Q\"\u0012<f]Rd\u0015n\u001d;f]\u0016\u0014\bf\u0001\u0001\u0002\nA!\u00111BA\t\u001b\t\tiAC\u0002\u0002\u0010Y\f!b\u001d;fe\u0016|G/\u001f9f\u0013\u0011\t\u0019\"!\u0004\u0003\u000fM+'O^5dK\u0002")
public class TemplateMetadataService
implements Logging,
WorkdirSupport {
    private final TemplateMetadataRepository templateMetadataRepository;
    private final Path cacheDir;
    private final Path logoDir;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public <T> T withWorkDir(Function0<T> block) {
        return (T)WorkdirSupport.withWorkDir$(this, block);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        TemplateMetadataService templateMetadataService = this;
        synchronized (templateMetadataService) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private Path cacheDir() {
        return this.cacheDir;
    }

    private Path logoDir() {
        return this.logoDir;
    }

    public synchronized File getLogo(String logoId) {
        this.makeDirs(this.logoDir());
        TemplateLogo templateLogo = (TemplateLogo)this.templateMetadataRepository.findTemplateLogoById(logoId).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException("Repository entity [%s] not found", new Object[]{logoId});
        });
        File maybeLogoFile = new File(PathSugar$.MODULE$.path2File(this.cacheDir()), templateLogo.getExportFilename());
        if (maybeLogoFile.exists() && maybeLogoFile.isFile()) {
            return maybeLogoFile;
        }
        return this.fetchLogoFromDatabase(templateLogo);
    }

    private File fetchLogoFromDatabase(TemplateLogo templateLogo) {
        Try result = (Try)this.withWorkDir((Function0 & Serializable)() -> Using.Manager$.MODULE$.apply((Function1 & Serializable)use -> {
            File newFile = new File(PathSugar$.MODULE$.path2File(this.cacheDir()), templateLogo.getExportFilename());
            FileOutputStream fos = (FileOutputStream)use.apply((Object)new FileOutputStream(newFile), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            InputStream is = (InputStream)use.apply((Object)templateLogo.getFile().getInputStream(), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            return newFile;
        }));
        return (File)result.get();
    }

    private void makeDirs(Path dirPath) {
        if (!dirPath.toFile().isDirectory()) {
            PathSugar$.MODULE$.path2File(dirPath).mkdirs();
            return;
        }
    }

    private void cleanCache() {
        try {
            FileSystemUtils.deleteRecursively((Path)this.logoDir());
        }
        catch (Throwable e) {
            this.logger().warn((Function0 & Serializable)() -> "Unable to delete " + this.logoDir());
        }
    }

    @EventListener
    public void onApplicationReadyEvent(ApplicationReadyEvent event) {
        this.cleanCache();
    }

    public TemplateMetadataService(TemplateMetadataRepository templateMetadataRepository) {
        this.templateMetadataRepository = templateMetadataRepository;
        Logging.$init$((Logging)this);
        WorkdirSupport.$init$(this);
        this.cacheDir = Paths.get("cache", new String[0]);
        this.logoDir = this.cacheDir().resolve("template-logo");
    }
}

