/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.features.TaskUpdateVersioningFeature;
import com.xebialabs.xlrelease.param.IdParam;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.TaskGranularPermissions;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions;
import com.xebialabs.xlrelease.service.DependencyService;
import com.xebialabs.xlrelease.service.GateConditionService;
import com.xebialabs.xlrelease.service.IdAndStatus;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.views.DependencyTargetView;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.GateConditionView;
import com.xebialabs.xlrelease.views.PlanItemView;
import com.xebialabs.xlrelease.views.ReleaseView;
import com.xebialabs.xlrelease.views.converters.DependencyViewConverter;
import io.micrometer.core.annotation.Timed;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/gates")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class GatesResource {
    private ReleaseActorService releaseActorService;
    private GateConditionService conditions;
    private ReleaseService releaseService;
    private PermissionChecker permissions;
    private DependencyService dependencyService;
    private TaskService taskService;
    private TaskGranularPermissions taskPermissionChecker;
    private TaskUpdateVersioningFeature taskUpdateVersioningFeature;

    @Autowired
    public GatesResource(ReleaseActorService releaseActorService, GateConditionService conditions, ReleaseService releaseService, PermissionChecker permissions, DependencyService dependencyService, TaskService taskService, TaskGranularPermissions taskPermissionChecker, TaskUpdateVersioningFeature taskUpdateVersioningFeature) {
        this.releaseActorService = releaseActorService;
        this.conditions = conditions;
        this.releaseService = releaseService;
        this.permissions = permissions;
        this.dependencyService = dependencyService;
        this.taskService = taskService;
        this.taskPermissionChecker = taskPermissionChecker;
        this.taskUpdateVersioningFeature = taskUpdateVersioningFeature;
    }

    @PUT
    @Timed
    @Path(value="conditions/{conditionId:.*Condition[^/-]*}")
    public GateConditionView updateCondition(@PathParam(value="conditionId") @IdParam String conditionId, @QueryParam(value="modifiedAt") Long modifiedAt, GateConditionView conditionView) {
        GateCondition gateCondition;
        String releaseId = Ids.releaseIdFrom((String)conditionId);
        boolean isTemplate = this.releaseService.isTemplate(releaseId);
        DateTime modifiedAtDate = this.getModifiedAtDate(modifiedAt);
        if (isTemplate && this.permissions.hasPermission(XLReleasePermissions.EDIT_TEMPLATE, releaseId)) {
            gateCondition = this.isTaskConcurrencyCheckEnabled() ? this.releaseActorService.updateGateConditionVersioned(conditionId, conditionView.toCondition(), modifiedAtDate) : this.releaseActorService.updateGateCondition(conditionId, conditionView.toCondition());
        } else if (this.permissions.isAllowedToWorkOnTask(Ids.getParentId((String)conditionId)) && this.checkHasEditTaskPermissionIfConditionTitleChanged(conditionId, conditionView, releaseId) || this.taskPermissionChecker.hasEditTaskConfigurationGranularPermission(releaseId)) {
            gateCondition = this.isTaskConcurrencyCheckEnabled() ? this.releaseActorService.updateGateConditionVersioned(conditionId, conditionView.toCondition(), modifiedAtDate) : this.releaseActorService.updateGateCondition(conditionId, conditionView.toCondition());
        } else {
            throw PermissionDeniedException.forPermission((Permission)(isTemplate ? XLReleasePermissions.EDIT_TEMPLATE : XLReleasePermissions.EDIT_RELEASE_TASK), (String)releaseId);
        }
        CiAttributes ciAttributes = this.getCiAttributes(Ids.getParentId((String)gateCondition.getId()));
        return new GateConditionView(gateCondition, ciAttributes.getLastModifiedBy(), this.getLastModifiedDate(ciAttributes));
    }

    @POST
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/conditions")
    public GateConditionView createCondition(@PathParam(value="gateId") @IdParam String gateId) {
        this.taskPermissionChecker.checkHasEditTaskOrEditTaskConfiguration(Ids.releaseIdFrom((String)gateId));
        GateCondition gateCondition = this.releaseActorService.createGateCondition(gateId);
        CiAttributes ciAttributes = this.getCiAttributes(gateId);
        return new GateConditionView(gateCondition, ciAttributes.getLastModifiedBy(), this.getLastModifiedDate(ciAttributes));
    }

    @DELETE
    @Timed
    @Path(value="conditions/{conditionId:.*Condition[^/-]*}")
    public void deleteCondition(@PathParam(value="conditionId") @IdParam String conditionId) {
        this.taskPermissionChecker.checkHasEditTaskOrEditTaskConfiguration(Ids.releaseIdFrom((String)conditionId));
        this.releaseActorService.deleteGateCondition(conditionId);
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependencies")
    public List<DependencyView> getDependencies(@PathParam(value="gateId") @IdParam String gateId) {
        GateTask gateTask = (GateTask)this.taskService.findByIdIncludingArchived(gateId);
        this.permissions.checkViewTask((Task)gateTask);
        return gateTask.getDependencies().stream().map(DependencyViewConverter::toDependencyView).collect(Collectors.toList());
    }

    @POST
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependencies")
    public DependencyView addDependency(@PathParam(value="gateId") @IdParam String gateId, DependencyView dependencyView) {
        this.taskPermissionChecker.checkHasEditTaskOrEditTaskConfiguration(Ids.releaseIdFrom((String)gateId));
        if (dependencyView.hasFixedTarget()) {
            this.permissions.checkView(Ids.releaseIdFrom((String)dependencyView.toTargetId()));
        }
        Dependency dependency = this.releaseActorService.createDependency(gateId, dependencyView.toTargetIdOrVariable());
        CiAttributes ciAttributes = this.getCiAttributes(gateId);
        DependencyView updatedDependencyView = DependencyViewConverter.toDependencyView(dependency);
        updatedDependencyView.setLastModifiedBy(ciAttributes.getLastModifiedBy());
        updatedDependencyView.setLastModifiedAt(this.getLastModifiedDate(ciAttributes));
        return updatedDependencyView;
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependency-target-candidates")
    public List<PlanItemView> getDependencyTargetCandidates(@PathParam(value="gateId") @IdParam String gateId) {
        List<Release> dependencyTargetCandidates = this.dependencyService.findAllDependencyCandidates(gateId);
        return dependencyTargetCandidates.stream().map(PlanItemView::new).collect(Collectors.toList());
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependency-target-candidates/{releaseId:.*Release[^/-]*}")
    public ReleaseView loadDependencyTargetCandidate(@PathParam(value="gateId") @IdParam String gateId, @PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        return new ReleaseView(this.dependencyService.getDependencyCandidate(gateId, releaseId));
    }

    @GET
    @Timed
    @Path(value="{gateId:.*Task[^/-]*}/dependency-target-statuses")
    public List<DependencyTargetView> getDependenciesStatuses(@PathParam(value="gateId") @IdParam String gateId) {
        GateTask gateTask = (GateTask)this.taskService.findByIdIncludingArchived(gateId, ResolveOptions.WITH_DECORATORS());
        this.permissions.checkViewTask((Task)gateTask);
        return gateTask.getDependencies().stream().map(dependency -> {
            String targetId = dependency.getTargetId();
            try {
                IdAndStatus r = this.dependencyService.findDependencyTargetByTargetId(targetId);
                return new DependencyTargetView(r.id(), r.status());
            }
            catch (NotFoundException ex) {
                return new DependencyTargetView(targetId, "not_found");
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private boolean checkHasEditTaskPermissionIfConditionTitleChanged(String conditionId, GateConditionView conditionView, String releaseId) {
        if (!com.google.common.base.Objects.equal((Object)this.conditions.findById(conditionId).getTitle(), (Object)conditionView.toCondition().getTitle())) {
            return this.permissions.hasPermission(XLReleasePermissions.EDIT_RELEASE_TASK, releaseId);
        }
        return true;
    }

    private boolean isTaskConcurrencyCheckEnabled() {
        return this.taskUpdateVersioningFeature.concurrentTaskModificationProtectionEnabled();
    }

    private DateTime getModifiedAtDate(Long modifiedAt) {
        if (modifiedAt != null) {
            return new DateTime((Object)modifiedAt);
        }
        return null;
    }

    private CiAttributes getCiAttributes(String gateId) {
        Object updatedTask = this.taskService.findById(gateId, ResolveOptions.WITHOUT_DECORATORS());
        return updatedTask.get$ciAttributes();
    }

    private Date getLastModifiedDate(CiAttributes ciAttributes) {
        if (ciAttributes.getLastModifiedAt() != null) {
            return ciAttributes.getLastModifiedAt().toDate();
        }
        return null;
    }
}

