package com.xebialabs.xlrelease.support.report.repository

sealed abstract class TaskTypeCategory(val value: String) {
  override def toString: String = value
}

object TaskTypeCategory {
  case object Container extends TaskTypeCategory("c")

  case object Regular extends TaskTypeCategory("r")

  case object Unknown extends TaskTypeCategory("u")
}

sealed abstract class PluginType(val value: String) {
  override def toString: String = value
}

object PluginType {
  case object BuiltIn extends PluginType("b")

  case object Official extends PluginType("o")

  case object Custom extends PluginType("c")

  case object Extension extends PluginType("e")
}

case class TaskTypeUsage(taskType: String,
                         totalNumberOfTimesTaskUsed: Int,
                         taskUsedInNoOfRelease: Int,
                         taskCategory: TaskTypeCategory = TaskTypeCategory.Unknown,
                         pluginUrl: String = "NA",
                         pluginName: String = "NA",
                         pluginVersion: String = "NA",
                         pluginType: PluginType = PluginType.BuiltIn) {
  def this() = this("NA", 0, 0)

  def print(sep: String = "|"): String = {
    val formattedUsage = s"$taskCategory$sep$taskType$sep$totalNumberOfTimesTaskUsed$sep$taskUsedInNoOfRelease"
    pluginType match {
      case PluginType.BuiltIn | PluginType.Extension => formattedUsage
      case PluginType.Official | PluginType.Custom => s"$pluginType$sep$pluginName$sep$pluginVersion$sep$formattedUsage"
    }
  }
}
