/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.api.v1.FolderApi;
import com.xebialabs.xlrelease.api.v1.TeamFacade;
import com.xebialabs.xlrelease.api.v1.VariableComponent;
import com.xebialabs.xlrelease.api.v1.forms.CreateTeam;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.api.v1.forms.Variable;
import com.xebialabs.xlrelease.api.v1.views.TeamView;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.TeamPermissionOperations;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Page;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ExternalVariableService;
import com.xebialabs.xlrelease.service.FolderService;
import com.xebialabs.xlrelease.service.FolderVariableService;
import com.xebialabs.xlrelease.variable.VariableHelper;
import com.xebialabs.xlrelease.views.TemplateFilters;
import io.micrometer.core.annotation.Timed;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import scala.jdk.javaapi.CollectionConverters;

@Controller
public class FolderApiImpl
implements FolderApi {
    private final PermissionChecker permissions;
    private final FolderService folderService;
    private final TeamFacade teamFacade;
    private final FolderVariableService folderVariableService;
    private final ExternalVariableService externalVariableService;
    private final VariableComponent variableComponent;

    @Autowired
    public FolderApiImpl(PermissionChecker permissions, FolderService folderService, TeamFacade teamFacade, FolderVariableService folderVariableService, ExternalVariableService externalVariableService, VariableComponent variableComponent) {
        this.permissions = permissions;
        this.folderService = folderService;
        this.teamFacade = teamFacade;
        this.folderVariableService = folderVariableService;
        this.externalVariableService = externalVariableService;
        this.variableComponent = variableComponent;
    }

    @Timed
    public List<Folder> listRoot(Long page, Long resultPerPage, Integer depth, Boolean decorateWithPermissions) {
        return this.folderService.listViewableFolders(Folder.ROOT_FOLDER_ID, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultPerPage), Optional.ofNullable(depth)), Optional.ofNullable(decorateWithPermissions).orElse(false), true);
    }

    @Timed
    public List<Folder> list(String parentId, Long page, Long resultPerPage, Integer depth, Boolean decorateWithPermissions) {
        return this.folderService.listViewableFolders(parentId, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultPerPage), Optional.ofNullable(depth)), Optional.ofNullable(decorateWithPermissions).orElse(true), true);
    }

    @Timed
    public Folder find(String path, Integer depth) {
        Folder byPath = this.folderService.findByPath(path, Optional.ofNullable(depth).orElse(Page.DEFAULT_DEPTH()));
        if (!this.permissions.hasGlobalPermission(XLReleasePermissions.AUDIT_ALL)) {
            this.permissions.check(XLReleasePermissions.VIEW_FOLDER, byPath.getId());
        }
        return byPath;
    }

    @Timed
    public Folder getFolder(String folderId, Integer depth) {
        if (!this.permissions.hasGlobalPermission(XLReleasePermissions.AUDIT_ALL)) {
            this.permissions.check(XLReleasePermissions.VIEW_FOLDER, folderId);
        }
        return this.folderService.findViewableFoldersById(folderId, Optional.ofNullable(depth).orElse(Page.DEFAULT_DEPTH()), true);
    }

    @Timed
    public Folder getFolder(String folderId) {
        return this.getFolder(folderId, null);
    }

    @Timed
    public List<Release> getTemplates(String folderId, String kind, Long page, Long resultPerPage, Integer depth) {
        return this.getTemplates(folderId, null, null, kind, page, resultPerPage);
    }

    @Timed
    public List<Release> getTemplates(String folderId, String kind, Long page, Long resultPerPage) {
        return this.getTemplates(folderId, null, null, kind, page, resultPerPage);
    }

    @Timed
    public List<Release> getTemplates(String folderId, String title, List<String> tags, String kind, Long page, Long resultPerPage) {
        this.permissions.checkViewFolder(folderId);
        if (!Ids.isRoot((String)folderId) && !this.permissions.hasGlobalPermission(XLReleasePermissions.AUDIT_ALL)) {
            this.permissions.check(XLReleasePermissions.VIEW_TEMPLATE, folderId);
        }
        TemplateFilters filters = new TemplateFilters(folderId, title, tags, ReleaseKind.fromString((String)kind));
        return this.folderService.searchTemplates(filters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultPerPage), Optional.empty()), true);
    }

    @Timed
    public List<Release> getTemplates(String folderId) {
        return this.getTemplates(folderId, null, null);
    }

    @Timed
    public List<Release> searchReleases(String folderId, Long page, Long resultPerPage, Integer depth, ReleasesFilters releasesFilters) {
        return this.searchReleases(folderId, page, resultPerPage, releasesFilters);
    }

    @Timed
    public List<Release> searchReleases(String folderId, Long page, Long resultPerPage, ReleasesFilters releasesFilters) {
        if (!Ids.isRoot((String)folderId)) {
            this.permissions.checkViewFolder(folderId);
            this.permissions.canViewRelease(folderId);
        }
        if (null == releasesFilters) {
            releasesFilters = new ReleasesFilters();
        }
        return this.folderService.searchReleases(folderId, releasesFilters, Page.parse(Optional.ofNullable(page), Optional.ofNullable(resultPerPage), Optional.empty())).getReleases();
    }

    @Timed
    public List<Release> searchReleases(String folderId, ReleasesFilters releasesFilters) {
        return this.searchReleases(folderId, null, null, null, releasesFilters);
    }

    @Timed
    public void moveTemplate(String folderId, String templateId, Boolean mergeTeams) {
        this.permissions.checkEdit(templateId);
        this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, folderId);
        boolean shouldMergeTeams = Optional.ofNullable(mergeTeams).orElse(false);
        if (shouldMergeTeams) {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER_SECURITY, folderId);
        }
        this.folderService.moveTemplate(folderId, templateId, shouldMergeTeams);
    }

    @Timed
    public void moveTemplate(String folderId, String templateId) {
        this.moveTemplate(folderId, templateId, null);
    }

    @Timed
    public Folder addFolder(String parentId, Folder folder) {
        if (Folder.ROOT_FOLDER_ID.equals(parentId)) {
            this.permissions.check(XLReleasePermissions.CREATE_TOP_LEVEL_FOLDER);
        } else {
            this.permissions.check(XLReleasePermissions.EDIT_FOLDER, parentId);
        }
        return this.folderService.create(parentId, folder);
    }

    @Timed
    public void delete(String folderId) {
        Checks.checkArgument((!Folder.ROOT_FOLDER_ID.equals(folderId) ? 1 : 0) != 0, (String)"Cannot delete root folder", (Object[])new Object[0]);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, folderId);
        this.folderService.delete(folderId);
    }

    @Timed
    public Folder move(String folderId, String newParentId) {
        Checks.checkArgument((!Folder.ROOT_FOLDER_ID.equals(folderId) ? 1 : 0) != 0, (String)"Cannot move root folder", (Object[])new Object[0]);
        Folder folder = this.folderService.findById(folderId, 0);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, folder.getId());
        if (Folder.ROOT_FOLDER_ID.equals(newParentId)) {
            this.permissions.check(XLReleasePermissions.CREATE_TOP_LEVEL_FOLDER);
            return this.folderService.move(folder.getId(), Folder.ROOT_FOLDER_ID);
        }
        Folder newFolder = this.folderService.findById(newParentId, 0);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, newFolder.getId());
        return this.folderService.move(folder.getId(), newFolder.getId());
    }

    @Timed
    public void rename(String folderId, String newName) {
        Checks.checkArgument((!Folder.ROOT_FOLDER_ID.equals(folderId) ? 1 : 0) != 0, (String)"Cannot rename root folder", (Object[])new Object[0]);
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER, folderId);
        this.folderService.rename(folderId, newName);
    }

    @Timed
    public List<String> getPermissions() {
        ArrayList<String> folderPermissions = new ArrayList<String>();
        folderPermissions.addAll(XLReleasePermissions.getFolderPermissions());
        folderPermissions.addAll(XLReleasePermissions.getTemplatePermissions());
        return folderPermissions;
    }

    @Timed
    public List<TeamView> getTeams(String folderId) {
        return this.teamFacade.getTeams(folderId);
    }

    @Timed
    public List<TeamView> setTeams(String folderId, List<TeamView> teamDtos) {
        return this.teamFacade.setTeams(folderId, teamDtos);
    }

    @Timed
    public boolean isFolderOwner(String folderId) {
        this.permissions.checkAny(folderId, XLReleasePermissions.VIEW_FOLDER_SECURITY, XLReleasePermissions.EDIT_FOLDER_SECURITY, XLReleasePermissions.EDIT_FOLDER_TEAMS);
        return this.permissions.isCurrentUserAdmin() || this.permissions.getUserFolderTeams(folderId).stream().anyMatch(TeamPermissionOperations::isFolderOwnerTeam);
    }

    @Timed
    public List<com.xebialabs.xlrelease.domain.variables.Variable> listVariables(String folderId, boolean folderOnly) {
        if (folderOnly) {
            return this.folderVariableService.getAllFromImmediateParent(folderId).getVariables();
        }
        return this.folderVariableService.getAllFromAncestry(folderId).getVariables();
    }

    @Timed
    public Map<String, String> listVariableValues(String folderId, boolean folderOnly) {
        return VariableHelper.getVariableValuesAsStrings(this.listVariables(folderId, folderOnly));
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable createVariable(String folderId, Variable variable) {
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER_VARIABLES, folderId);
        this.externalVariableService.checkExistsAndCorrectType(variable.getExternalVariableValue());
        com.xebialabs.xlrelease.domain.variables.Variable releaseVariable = variable.toReleaseVariable();
        releaseVariable.setFolderId(folderId);
        return this.folderVariableService.createFolderVariable(releaseVariable);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable getVariable(String folderId, String variableId) {
        return this.folderVariableService.findById(variableId);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(String folderId, String variableId, com.xebialabs.xlrelease.domain.variables.Variable variable) {
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER_VARIABLES, folderId);
        variable.setId(variableId);
        variable.setFolderId(folderId);
        return this.folderVariableService.updateFolderVariable(variable);
    }

    @Timed
    public com.xebialabs.xlrelease.domain.variables.Variable updateVariable(String folderId, com.xebialabs.xlrelease.domain.variables.Variable variable) {
        return this.updateVariable(folderId, variable.getId(), variable);
    }

    @Timed
    public void deleteVariable(String folderId, String variableId) {
        this.permissions.check(XLReleasePermissions.EDIT_FOLDER_VARIABLES, folderId);
        this.folderVariableService.deleteFolderVariable(variableId);
    }

    public Collection<Object> getVariablePossibleValues(String variableId) {
        return this.variableComponent.getVariablePossibleValues(this.getVariable(null, variableId));
    }

    public Team getTeam(String folderId, String teamId) {
        return this.teamFacade.getTeam(folderId, teamId);
    }

    public Team findTeam(String folderId, String teamName) {
        return this.teamFacade.findTeam(folderId, teamName);
    }

    public String createTeam(String folderId, CreateTeam createTeam) {
        return this.teamFacade.createTeam(folderId, createTeam);
    }

    public void deleteTeamByName(String folderId, String teamName) {
        this.teamFacade.deleteTeamByName(folderId, teamName);
    }

    public void deleteTeamById(String folderId, String teamId) {
        this.teamFacade.deleteTeamById(folderId, teamId);
    }

    public void addPrincipalsToTeamById(String folderId, String teamId, List<String> principalNames) {
        this.teamFacade.addPrincipalsToTeamById(folderId, teamId, principalNames);
    }

    public void addPrincipalsToTeamByName(String folderId, String teamName, List<String> principalNames) {
        this.teamFacade.addPrincipalsToTeamByName(folderId, teamName, principalNames);
    }

    public void removePrincipalsFromTeamById(String folderId, String teamId, List<String> principalNames) {
        this.teamFacade.removePrincipalsFromTeamById(folderId, teamId, principalNames);
    }

    public void removePrincipalsFromTeamByName(String folderId, String teamName, List<String> principalNames) {
        this.teamFacade.removePrincipalsFromTeamByName(folderId, teamName, principalNames);
    }

    public void addRoleNamesToTeamById(String folderId, String teamId, List<String> roleNames) {
        this.teamFacade.addRoleNamesToTeamById(folderId, teamId, roleNames);
    }

    public void addRoleNamesToTeamByName(String folderId, String teamName, List<String> roleNames) {
        this.teamFacade.addRoleNamesToTeamByName(folderId, teamName, roleNames);
    }

    public void removeRoleNamesFromTeamById(String folderId, String teamId, List<String> roleNames) {
        this.teamFacade.removeRoleNamesFromTeamById(folderId, teamId, roleNames);
    }

    public void removeRoleNamesFromTeamByName(String folderId, String teamName, List<String> roleNames) {
        this.teamFacade.removeRoleNamesFromTeamByName(folderId, teamName, roleNames);
    }

    public void addPermissionsToTeamById(String folderId, String teamId, List<String> permissions) {
        this.teamFacade.addPermissionsToTeamById(folderId, teamId, permissions);
    }

    public void addPermissionsToTeamByName(String folderId, String teamName, List<String> permissions) {
        this.teamFacade.addPermissionsToTeamByName(folderId, teamName, permissions);
    }

    public void removePermissionsFromTeamById(String folderId, String teamId, List<String> permissions) {
        this.teamFacade.removePermissionsFromTeamById(folderId, teamId, permissions);
    }

    public void removePermissionsFromTeamByName(String folderId, String teamName, List<String> permissions) {
        this.teamFacade.removePermissionsFromTeamByName(folderId, teamName, permissions);
    }

    @Timed
    public List<String> getPathSegments(String folderId) {
        if (Strings.isBlank((String)folderId)) {
            return List.of();
        }
        if (Folder.ROOT_FOLDER_ID.equals(folderId)) {
            return List.of("/");
        }
        return CollectionConverters.asJava(this.folderService.getPath(folderId));
    }

    @Timed
    public String getPath(String folderId) {
        return this.getPathSegments(folderId).stream().skip(1L).collect(Collectors.joining("/", "/", ""));
    }
}

