/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.v1.impl;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.api.v1.CategoryApi;
import com.xebialabs.xlrelease.api.v1.filter.CategoryFilters;
import com.xebialabs.xlrelease.api.v1.forms.CategoryForm;
import com.xebialabs.xlrelease.api.v1.views.CategoryView;
import com.xebialabs.xlrelease.domain.Category;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.CategoryService;
import io.micrometer.core.annotation.Timed;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Controller
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001B\u0005\u000b\u0001]A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\tW\u0001\u0011\t\u0011)A\u0005Y!)!\u0007\u0001C\u0001g!)\u0001\b\u0001C!s!)1\u000e\u0001C!Y\")1\u000e\u0001C!w\"1q\u0010\u0001C!\u0003\u0003Aq!!\u0005\u0001\t\u0003\n\u0019BA\bDCR,wm\u001c:z\u0003BL\u0017*\u001c9m\u0015\tYA\"\u0001\u0003j[Bd'BA\u0007\u000f\u0003\t1\u0018G\u0003\u0002\u0010!\u0005\u0019\u0011\r]5\u000b\u0005E\u0011\u0012!\u0003=me\u0016dW-Y:f\u0015\t\u0019B#A\u0005yK\nL\u0017\r\\1cg*\tQ#A\u0002d_6\u001c\u0001aE\u0002\u00011\u0001\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0003C\tj\u0011\u0001D\u0005\u0003G1\u00111bQ1uK\u001e|'/_!qS\u0006y1-\u0019;fO>\u0014\u0018pU3sm&\u001cW\r\u0005\u0002'S5\tqE\u0003\u0002)!\u000591/\u001a:wS\u000e,\u0017B\u0001\u0016(\u0005=\u0019\u0015\r^3h_JL8+\u001a:wS\u000e,\u0017a\u00039fe6L7o]5p]N\u0004\"!\f\u0019\u000e\u00039R!a\f\t\u0002\u0011M,7-\u001e:jifL!!\r\u0018\u0003#A+'/\\5tg&|gn\u00115fG.,'/\u0001\u0004=S:LGO\u0010\u000b\u0004iY:\u0004CA\u001b\u0001\u001b\u0005Q\u0001\"\u0002\u0013\u0004\u0001\u0004)\u0003\"B\u0016\u0004\u0001\u0004a\u0013\u0001F:fCJ\u001c\u0007nQ1uK\u001e|'/[3t!\u0006<W\r\u0006\u0003;\u0019Rc\u0006cA\u001eE\r6\tAH\u0003\u0002>}\u00051Am\\7bS:T!a\u0010!\u0002\t\u0011\fG/\u0019\u0006\u0003\u0003\n\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015c$\u0001\u0002)bO\u0016\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0007\u0002\u000bYLWm^:\n\u0005-C%\u0001D\"bi\u0016<wN]=WS\u0016<\b\"B'\u0005\u0001\u0004q\u0015aD2bi\u0016<wN]=GS2$XM]:\u0011\u0005=\u0013V\"\u0001)\u000b\u0005Ec\u0011A\u00024jYR,'/\u0003\u0002T!\ny1)\u0019;fO>\u0014\u0018PR5mi\u0016\u00148\u000fC\u0003V\t\u0001\u0007a+\u0001\u0003qC\u001e,\u0007CA,[\u001b\u0005A&\"A-\u0002\u000bM\u001c\u0017\r\\1\n\u0005mC&aA%oi\")Q\f\u0002a\u0001-\u0006q!/Z:vYR\u001c\b+\u001a:QC\u001e,\u0007F\u0001\u0003`!\t\u0001\u0017.D\u0001b\u0015\t\u00117-\u0001\u0006b]:|G/\u0019;j_:T!\u0001Z3\u0002\t\r|'/\u001a\u0006\u0003M\u001e\f!\"\\5de>lW\r^3s\u0015\u0005A\u0017AA5p\u0013\tQ\u0017MA\u0003US6,G-A\u0006bI\u0012\u001c\u0015\r^3h_JLHCA7s!\tq\u0007/D\u0001p\u0015\ti\u0004#\u0003\u0002r_\nA1)\u0019;fO>\u0014\u0018\u0010C\u0003t\u000b\u0001\u0007A/\u0001\u0007dCR,wm\u001c:z\r>\u0014X\u000e\u0005\u0002vq6\taO\u0003\u0002x\u0019\u0005)am\u001c:ng&\u0011\u0011P\u001e\u0002\r\u0007\u0006$XmZ8ss\u001a{'/\u001c\u0015\u0003\u000b}#\"!\u001c?\t\u000bu4\u0001\u0019A7\u0002\u0011\r\fG/Z4pefD#AB0\u0002\u001dU\u0004H-\u0019;f\u0007\u0006$XmZ8ssR)Q.a\u0001\u0002\u000e!9\u0011QA\u0004A\u0002\u0005\u001d\u0011!B2j+&$\u0007cA\r\u0002\n%\u0019\u00111\u0002\u000e\u0003\u000f%sG/Z4fe\")Qp\u0002a\u0001[\"\u0012qaX\u0001\u000fI\u0016dW\r^3DCR,wm\u001c:z)\u0011\t)\"a\u0007\u0011\u0007]\u000b9\"C\u0002\u0002\u001aa\u0013A!\u00168ji\"9\u0011Q\u0001\u0005A\u0002\u0005\u001d\u0001F\u0001\u0005`Q\r\u0001\u0011\u0011\u0005\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005!\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0002,\u0005\u0015\"AC\"p]R\u0014x\u000e\u001c7fe\u0002")
public class CategoryApiImpl
implements CategoryApi {
    private final CategoryService categoryService;
    private final PermissionChecker permissions;

    public String serviceName() {
        return super.serviceName();
    }

    @PublicApiMember
    public List<CategoryView> searchCategories(CategoryFilters categoryFilters, int page, int resultsPerPage) {
        return super.searchCategories(categoryFilters, page, resultsPerPage);
    }

    @Timed
    public Page<CategoryView> searchCategoriesPage(CategoryFilters categoryFilters, int page, int resultsPerPage) {
        Checks.checkArgument(((long)resultsPerPage <= 100L ? 1 : 0) != 0, (String)"Number of results per page cannot be more than %d", (Object[])new Object[]{BoxesRunTime.boxToLong((long)100L)});
        PageRequest pageable = PageRequest.of((int)page, (int)resultsPerPage);
        return this.categoryService.findBy(categoryFilters, (Pageable)pageable);
    }

    @Timed
    public Category addCategory(CategoryForm categoryForm) {
        Category category = new Category(categoryForm.getTitle(), categoryForm.isActive());
        return this.addCategory(category);
    }

    @Timed
    public Category addCategory(Category category) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.categoryService.create(category);
    }

    @Timed
    public Category updateCategory(Integer ciUid, Category category) {
        this.permissions.check(PlatformPermissions.ADMIN);
        category.setCiUid(ciUid);
        return this.categoryService.update(category);
    }

    @Timed
    public void deleteCategory(Integer ciUid) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.categoryService.delete(Predef$.MODULE$.Integer2int(ciUid));
    }

    public CategoryApiImpl(CategoryService categoryService, PermissionChecker permissions) {
        this.categoryService = categoryService;
        this.permissions = permissions;
    }
}

