package com.xebialabs.xlrelease.events.actions

import com.xebialabs.xlrelease.domain.events.ReleaseAbortScriptsAction
import com.xebialabs.xlrelease.events.{EventListener, Subscribe}
import com.xebialabs.xlrelease.repository.ReleaseRepository
import com.xebialabs.xlrelease.script.ScriptLifeCycle
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptions
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service

@Service
@EventListener
class ReleaseAbortScriptsActionHandler @Autowired()(val scriptLifeCycle: ScriptLifeCycle,
                                                    val releaseRepository: ReleaseRepository){

  @Subscribe
  def onReleaseAbortScriptsAction(action: ReleaseAbortScriptsAction): Unit = {
    releaseRepository
      .findById(action.releaseId, ResolveOptions.WITH_DECORATORS).getAllTasks.forEach(task => scriptLifeCycle.tryAborting(task.getExecutionId))
  }

}
