/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.security.filter;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.security.authentication.PersonalAuthenticationToken;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.www.BasicAuthenticationConverter;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class PATAuthenticationFilter
extends OncePerRequestFilter {
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final AuthenticationManager authenticationManager;
    private final String header;
    private final AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private final BasicAuthenticationConverter authenticationConverter = new BasicAuthenticationConverter();

    public PATAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint, String header) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.notNull((Object)authenticationEntryPoint, (String)"authenticationEntryPoint cannot be null");
        Assert.hasText((String)header, (String)"header cannot be empty");
        this.authenticationManager = authenticationManager;
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.header = header;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String token = this.getTokenFromHeader(request);
        if (token == null) {
            token = this.getTokenFromAuthorization(request);
        }
        if (token == null) {
            this.logger.trace((Object)"Did not process request since did not find personal access token");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            PersonalAuthenticationToken authenticationToken = new PersonalAuthenticationToken(token);
            authenticationToken.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            Authentication authenticationResult = this.authenticationManager.authenticate((Authentication)authenticationToken);
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(authenticationResult);
            SecurityContextHolder.setContext((SecurityContext)context);
            this.logger.debug((Object)String.format("Set SecurityContextHolder to %s", authenticationResult));
            this.setTokenExpiryHeader(response, authenticationResult);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (AuthenticationException ex) {
            SecurityContextHolder.clearContext();
            this.logger.trace((Object)"Failed to process authentication request", (Throwable)ex);
            this.authenticationEntryPoint.commence(request, response, ex);
        }
    }

    private String getTokenFromHeader(HttpServletRequest request) {
        return request.getHeader(this.header);
    }

    private String getTokenFromAuthorization(HttpServletRequest request) {
        UsernamePasswordAuthenticationToken token = this.authenticationConverter.convert(request);
        if (null == token) {
            this.logger.trace((Object)"Did not find username and password in Basic Authorization header");
            return null;
        }
        if (Strings.isNotBlank((String)token.getPrincipal().toString())) {
            this.logger.trace((Object)String.format("Found '%s' in Basic Authorization header", token.getPrincipal().toString()));
            return null;
        }
        this.logger.trace((Object)"Found personal access token in Basic Authorization header");
        return token.getCredentials().toString();
    }

    private void setTokenExpiryHeader(HttpServletResponse response, Authentication authentication) {
        PersonalAuthenticationToken pat;
        if (authentication instanceof PersonalAuthenticationToken && null != (pat = (PersonalAuthenticationToken)authentication).getExpiryDate()) {
            response.setDateHeader("Release-Personal-Token-Expiration", pat.getExpiryDate().getTime());
        }
    }
}

