package com.xebialabs.xlrelease.views.converters;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.views.PhaseFullView;

@Component
public class PhaseViewConverter implements PlanItemConverter {
    private TasksViewConverter tasksViewConverter;

    @Autowired
    public PhaseViewConverter(final TasksViewConverter tasksViewConverter) {
        this.tasksViewConverter = tasksViewConverter;
    }

    public PhaseFullView toFullView(Phase phase, List<Type> allowedTaskTypesForAuthenticatedUser) {
        PhaseFullView phaseFullView = new PhaseFullView();

        populatePlanItemView(phaseFullView, phase);

        phaseFullView.setOrigin(!StringUtils.hasText(phase.getOriginId())); // I am the original when I have no originId
        boolean isPhaseCopied = phase.isPhaseCopied();
        if (isPhaseCopied) {
            phaseFullView.setMostRecentCopy(false);
        } else {
            // so this phase is the latest one, but is it also the latest one from which it is copied?
            // Ie, if this is DEV(2) copied from DEV, is it the first, second, etc or last copy? We only want the last copy.
            phaseFullView.setMostRecentCopy(phase.isLatestCopy());
        }

        phaseFullView.setOriginId(phase.getOriginId());

        phaseFullView.setStatus(phase.getStatus());
        if (phase.getTasks() != null) {
            phaseFullView.setTasks(tasksViewConverter.toFullView(phase.getTasks(), allowedTaskTypesForAuthenticatedUser));
            int taskFailureCount = 0;
            int taskFlaggedCount = 0;
            int taskDelayCount = 0;

            for (Task task : phase.getAllTasks()) {
                if (task.hasBeenDelayed()) {
                    taskDelayCount++;
                }
                if (task.hasBeenFlagged()) {
                    taskFlaggedCount++;
                }
                if (!task.isTaskGroup()) {
                    taskFailureCount += task.getFailuresCount();
                }
            }

            phaseFullView.setTaskDelayCount(taskDelayCount);
            phaseFullView.setTaskFlaggedCount(taskFlaggedCount);
            phaseFullView.setTaskFailureCount(taskFailureCount);
        }
        phaseFullView.setColor(phase.getColor());

        return phaseFullView;
    }

}
