/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.xebialabs.xlrelease.api.internal.EffectiveSecurity;
import com.xebialabs.xlrelease.domain.ReleaseKind;
import com.xebialabs.xlrelease.domain.status.ReleaseStatus;
import com.xebialabs.xlrelease.views.BaseView;
import com.xebialabs.xlrelease.views.Flag;
import com.xebialabs.xlrelease.views.PhaseOverviewView;
import com.xebialabs.xlrelease.views.PlanItemFullView;
import com.xebialabs.xlrelease.views.ReleaseExtensionView;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.UserView;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ReleaseOverviewView
extends PlanItemFullView
implements BaseView {
    private ReleaseStatus status;
    private Flag releaseFlag;
    private Flag flag;
    private boolean archived;
    private Map<String, Object> syntheticProperties;
    private Map<String, ReleaseExtensionView> extensions;
    private String currentPhase;
    private TaskFullView currentTask;
    private List<PhaseOverviewView> phases;
    private Map<String, String> variables;
    private EffectiveSecurity security;
    private UserView owner;
    private List<String> tags;
    private ReleaseKind kind;
    private Long executionDuration;

    public ReleaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(ReleaseStatus status) {
        this.status = status;
    }

    public Flag getReleaseFlag() {
        return this.releaseFlag;
    }

    public void setReleaseFlag(Flag releaseFlag) {
        this.releaseFlag = releaseFlag;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public String getCurrentPhase() {
        return this.currentPhase;
    }

    public void setCurrentPhase(String currentPhase) {
        this.currentPhase = currentPhase;
    }

    public TaskFullView getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(TaskFullView currentTask) {
        this.currentTask = currentTask;
    }

    public Map<String, Object> getSyntheticProperties() {
        return this.syntheticProperties;
    }

    @Override
    public void setSyntheticProperties(Map<String, Object> syntheticProperties) {
        this.syntheticProperties = syntheticProperties;
    }

    public Map<String, ReleaseExtensionView> getExtensions() {
        return this.extensions;
    }

    public List<PhaseOverviewView> getPhases() {
        return this.phases;
    }

    public void setPhases(List<PhaseOverviewView> phases) {
        this.phases = phases;
    }

    @Override
    public void setExtensions(Map<String, ReleaseExtensionView> extensions) {
        this.extensions = extensions;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public UserView getOwner() {
        return this.owner;
    }

    public void setOwner(UserView owner) {
        this.owner = owner;
    }

    public EffectiveSecurity getSecurity() {
        return this.security;
    }

    public void setSecurity(EffectiveSecurity security) {
        this.security = security;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public ReleaseKind getKind() {
        return this.kind;
    }

    public void setKind(ReleaseKind kind) {
        this.kind = kind;
    }

    public Long getExecutionDuration() {
        if (null == this.executionDuration) {
            Instant startInstant;
            Instant now = Instant.now();
            Instant instant = startInstant = this.getStartDate() == null ? now : this.getStartDate().toInstant();
            if (Arrays.asList(ReleaseStatus.COMPLETED, ReleaseStatus.ABORTED).contains(this.getStatus())) {
                Instant endInstant = this.getEndDate() == null ? now : this.getEndDate().toInstant();
                this.executionDuration = Duration.between(startInstant, endInstant).getSeconds();
            } else {
                this.executionDuration = Duration.between(startInstant, now).getSeconds();
            }
        }
        return this.executionDuration;
    }
}

