package com.xebialabs.xlrelease.views.converters;

import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.views.PlanItemFullView;

import static com.xebialabs.xlrelease.views.converters.DurationViewConverter.toDurationView;

public interface PlanItemConverter {

    default void populatePlanItemView(PlanItemFullView view, PlanItem planItem) {
        view.setId(planItem.getId());
        view.setTitle(planItem.getTitle());
        view.setDescription(planItem.getDescription());
        view.setScheduledStartDate(planItem.getScheduledStartDate());
        view.setDueDate(planItem.getDueDate());
        view.setStartDate(planItem.getStartDate());
        view.setEndDate(planItem.getEndDate());
        view.setType(planItem.getType().toString());
        view.setHasBeenStarted(planItem.hasBeenStarted());
        view.setUpdatable(planItem.isUpdatable());
        view.setActive(planItem.isActive());
        view.setDone(planItem.isDone());
        view.setPlannedDuration(toDurationView(planItem.getPlannedDuration()));
    }

}
