package com.xebialabs.xlrelease.views;

import java.util.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;

import com.xebialabs.deployit.plumbing.MaskedCiSerializer;
import com.xebialabs.deployit.plumbing.TaskRecoverOpDeserializer;
import com.xebialabs.deployit.plumbing.TaskRecoverOpSerializer;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.recover.TaskRecoverOp;
import com.xebialabs.xlrelease.domain.status.FlagStatus;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.serialization.json.jackson.CiDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.CiSerializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

import static com.google.common.collect.Maps.newHashMap;
import static com.google.common.collect.Sets.newHashSet;

public class TaskFullView extends PlanItemFullView {

    private UserView owner;
    private String team;
    private String scriptDefinitionType;
    private TaskStatus status;
    private String precondition;
    private String failureHandler;
    @JsonSerialize(using = TaskRecoverOpSerializer.class)
    @JsonDeserialize(using = TaskRecoverOpDeserializer.class)
    private TaskRecoverOp taskRecoverOp;
    private Flag flag = new Flag(FlagStatus.OK);
    private String phaseTitle;
    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String releaseId;
    private String releaseTitle;
    private String addedComment;
    private int numberOfComments;
    private UserView releaseOwner;
    private List<String> tags;
    private UserView lastStatusChangeBy;


    private String server;
    private String deploymentPackage;
    private String environment;
    private String username;

    private VariableOrPasswordView password;
    private String statusLine;

    private List<GateConditionView> conditions;
    private List<DependencyView> dependencies;

    private String script;
    private boolean ignoreScriptVariableInterpolation;
    private boolean keepPreviousOutputPropertiesOnRetry;
    private int scriptTimeout;

    private List<TaskFullView> tasks;
    private List<LinkView> links;

    private boolean isAutomated;
    private Map<String, Object> inputProperties = newHashMap();
    private Map<String, Object> outputProperties = newHashMap();

    private List<AttachmentView> attachments;

    private boolean waitForScheduledStartDate = true;
    private boolean delayDuringBlackout = false;

    private boolean postponedDueToBlackout = false;
    private boolean postponedUntilEnvironmentsAreReserved = false;
    private Date originalScheduledStartDate;

    private String typeDisplayGroup;
    private String typeDisplayName;
    private String outputVarHelpText;
    private String color;
    private String customIconLocation;
    private String customIconClass;

    private boolean editable;
    private boolean preconditionEnabled;
    private boolean failureHandlerEnabled;
    private boolean taskFailureHandlerEnabled;
    private boolean checkAttributes;

    // flagsCount and delaysCount will be equal to 1 except for task group for which we sum counters of subtasks
    private int flagsCount;
    private int delaysCount;
    private int failuresCount;

    private Map<String, String> variableMapping = newHashMap();

    private boolean locked;

    // UserInputTask / CreateReleaseTask variables
    @JsonSerialize(contentUsing = MaskedCiSerializer.class)
    @JsonDeserialize(contentUsing = CiDeserializer.class)
    private List<Variable> variables = Lists.newArrayList();

    @JsonSerialize(contentUsing = CiSerializer.class)
    @JsonDeserialize(contentUsing = CiDeserializer.class)
    private List<Facet> facets = Lists.newArrayList();

    // CreateReleaseTask
    private String newReleaseTitle;
    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    private String templateId;
    private String folderId;
    private String riskProfileId;
    private String createdReleaseId;
    private String createdReleaseTitle;
    private boolean startRelease;
    private boolean waitForRelease;
    private Set<String> releaseTags;

    // NotificationTask
    private String from;
    private Set<String> addresses;
    private String subject;
    private String body;
    private Set<String> cc;
    private Set<String> bcc;
    private String replyTo;
    private String mailPriority;

    private boolean containerTask;

    private Set<UserView> watchers = newHashSet();

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public Set<String> getCc() {
        return cc;
    }

    public void setCc(final Set<String> cc) {
        this.cc = cc;
    }

    public Set<String> getBcc() {
        return bcc;
    }

    public void setBcc(final Set<String> bcc) {
        this.bcc = bcc;
    }

    public String getReplyTo() {
        return replyTo;
    }

    public void setReplyTo(final String replyTo) {
        this.replyTo = replyTo;
    }

    public String getMailPriority() {
        return mailPriority;
    }

    public void setMailPriority(final String mailPriority) {
        this.mailPriority = mailPriority;
    }

    public UserView getOwner() {
        return owner;
    }

    public void setOwner(UserView owner) {
        this.owner = owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    @JsonIgnore
    public String getOwnerUsername() {
        return hasOwner() ? getOwner().getUsername() : null;
    }

    public String getScriptDefinitionType() {
        return scriptDefinitionType;
    }

    public void setScriptDefinitionType(String scriptDefinitionType) {
        this.scriptDefinitionType = scriptDefinitionType;
    }

    public boolean isIgnoreScriptVariableInterpolation() {
        return ignoreScriptVariableInterpolation;
    }

    public void setIgnoreScriptVariableInterpolation(final boolean ignoreScriptVariableInterpolation) {
        this.ignoreScriptVariableInterpolation = ignoreScriptVariableInterpolation;
    }

    public TaskStatus getStatus() {
        return status;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public Flag getFlag() {
        return flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public String getPhaseTitle() {
        return phaseTitle;
    }

    public void setPhaseTitle(String phaseTitle) {
        this.phaseTitle = phaseTitle;
    }

    public String getReleaseId() {
        return releaseId;
    }

    public void setReleaseId(String releaseId) {
        this.releaseId = releaseId;
    }

    public String getReleaseTitle() {
        return releaseTitle;
    }

    public void setReleaseTitle(String releaseTitle) {
        this.releaseTitle = releaseTitle;
    }

    public void setAddedComment(String addedComment) {
        this.addedComment = addedComment;
    }

    public String getAddedComment() {
        return addedComment;
    }

    public boolean hasAddedComment() {
        return addedComment != null;
    }

    public int getNumberOfComments() {
        return numberOfComments;
    }

    public void setNumberOfComments(final int numberOfComments) {
        this.numberOfComments = numberOfComments;
    }

    public String getTeam() {
        return team;
    }

    public void setTeam(String team) {
        this.team = team;
    }

    public String getServer() {
        return server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getDeploymentPackage() {
        return deploymentPackage;
    }

    public void setDeploymentPackage(String deploymentPackage) {
        this.deploymentPackage = deploymentPackage;
    }

    public String getEnvironment() {
        return environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public List<GateConditionView> getConditions() {
        return conditions;
    }

    public void setConditions(final List<GateConditionView> conditions) {
        this.conditions = conditions;
    }

    public UserView getReleaseOwner() {
        return releaseOwner;
    }

    public void setReleaseOwner(final UserView releaseOwner) {
        this.releaseOwner = releaseOwner;
    }

    public List<DependencyView> getDependencies() {
        return dependencies;
    }

    public void setDependencies(final List<DependencyView> dependencies) {
        this.dependencies = dependencies;
    }

    public Set<String> getAddresses() {
        return addresses;
    }

    public void setAddresses(Set<String> addresses) {
        this.addresses = addresses;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getScript() {
        return script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public List<TaskFullView> getTasks() {
        return tasks;
    }

    public void setTasks(List<TaskFullView> tasks) {
        this.tasks = tasks;
    }

    public List<LinkView> getLinks() {
        return links;
    }

    public void setLinks(final List<LinkView> links) {
        this.links = links;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(final String username) {
        this.username = username;
    }

    public VariableOrPasswordView getPassword() {
        return password;
    }

    public void setPassword(final VariableOrPasswordView password) {
        this.password = password;
    }

    public boolean isAutomated() {
        return isAutomated;
    }

    public void setAutomated(boolean automated) {
        isAutomated = automated;
    }

    public Map<String, Object> getInputProperties() {
        return inputProperties;
    }

    public void setInputProperties(Map<String, Object> inputProperties) {
        this.inputProperties = inputProperties;
    }

    public Map<String, Object> getOutputProperties() {
        return outputProperties;
    }

    public void setOutputProperties(Map<String, Object> outputProperties) {
        this.outputProperties = outputProperties;
    }

    public boolean isWaitForScheduledStartDate() {
        return waitForScheduledStartDate;
    }

    public void setWaitForScheduledStartDate(boolean waitForScheduledStartDate) {
        this.waitForScheduledStartDate = waitForScheduledStartDate;
    }

    public boolean isDelayDuringBlackout() {
        return delayDuringBlackout;
    }

    public void setDelayDuringBlackout(final boolean delayDuringBlackout) {
        this.delayDuringBlackout = delayDuringBlackout;
    }

    public String getTypeDisplayGroup() {
        return typeDisplayGroup;
    }

    public void setTypeDisplayGroup(String typeDisplayGroup) {
        this.typeDisplayGroup = typeDisplayGroup;
    }

    public String getTypeDisplayName() {
        return typeDisplayName;
    }

    public void setTypeDisplayName(String typeDisplayName) {
        this.typeDisplayName = typeDisplayName;
    }

    public String getOutputVarHelpText() {
        return outputVarHelpText;
    }

    public void setOutputVarHelpText(String outputVarHelpText) {
        this.outputVarHelpText = outputVarHelpText;
    }

    public String getColor() {
        return color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getCustomIconLocation() {
        return customIconLocation;
    }

    public void setCustomIconLocation(String customIconLocation) {
        this.customIconLocation = customIconLocation;
    }

    public String getCustomIconClass() {
        return customIconClass;
    }

    public void setCustomIconClass(String customIconClass) {
        this.customIconClass = customIconClass;
    }

    public List<AttachmentView> getAttachments() {
        return attachments;
    }

    public void setAttachments(final List<AttachmentView> attachments) {
        this.attachments = attachments;
    }

    public int getFlagsCount() {
        return flagsCount;
    }

    public void setFlagsCount(final int flagsCount) {
        this.flagsCount = flagsCount;
    }

    public int getDelaysCount() {
        return delaysCount;
    }

    public void setDelaysCount(final int delaysCount) {
        this.delaysCount = delaysCount;
    }

    public int getFailuresCount() {
        return failuresCount;
    }

    public void setFailuresCount(final int failuresCount) {
        this.failuresCount = failuresCount;
    }

    public void setEditable(final boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return editable;
    }

    public String getPrecondition() {
        return precondition;
    }

    public void setPrecondition(String precondition) {
        this.precondition = precondition;
    }

    public boolean isPreconditionEnabled() {
        return preconditionEnabled;
    }

    public void setPreconditionEnabled(final boolean preconditionEnabled) {
        this.preconditionEnabled = preconditionEnabled;
    }

    public String getFailureHandler() {
        return failureHandler;
    }

    public void setFailureHandler(String failureHandler) {
        this.failureHandler = failureHandler;
    }

    public TaskRecoverOp getTaskRecoverOp() {
        return taskRecoverOp;
    }

    public void setTaskRecoverOp(final TaskRecoverOp taskRecoverOp) {
        this.taskRecoverOp = taskRecoverOp;
    }

    public boolean isFailureHandlerEnabled() {
        return failureHandlerEnabled;
    }

    public void setFailureHandlerEnabled(final boolean failureHandlerEnabled) {
        this.failureHandlerEnabled = failureHandlerEnabled;
    }

    public boolean isTaskFailureHandlerEnabled() {
        return taskFailureHandlerEnabled;
    }

    public void setTaskFailureHandlerEnabled(final boolean taskFailureHandlerEnabled) {
        this.taskFailureHandlerEnabled = taskFailureHandlerEnabled;
    }

    public Map<String, String> getVariableMapping() {
        return variableMapping;
    }

    public void setVariableMapping(final Map<String, String> variableMapping) {
        this.variableMapping = variableMapping;
    }

    public List<Variable> getVariables() {
        return variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public String getNewReleaseTitle() {
        return newReleaseTitle;
    }

    public void setNewReleaseTitle(final String newReleaseTitle) {
        this.newReleaseTitle = newReleaseTitle;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(final String templateId) {
        this.templateId = templateId;
    }

    public String getFolderId() {
        return folderId;
    }

    public void setFolderId(final String folderId) {
        this.folderId = folderId;
    }

    public String getRiskProfileId() {
        return riskProfileId;
    }

    public void setRiskProfileId(final String riskProfileId) {
        this.riskProfileId = riskProfileId;
    }

    public String getCreatedReleaseId() {
        return createdReleaseId;
    }

    public void setCreatedReleaseId(final String createdReleaseId) {
        this.createdReleaseId = createdReleaseId;
    }

    public String getCreatedReleaseTitle() {
        return createdReleaseTitle;
    }

    public void setCreatedReleaseTitle(final String createdReleaseTitle) {
        this.createdReleaseTitle = createdReleaseTitle;
    }

    public boolean getStartRelease() {
        return startRelease;
    }

    public void setStartRelease(final boolean startRelease) {
        this.startRelease = startRelease;
    }

    public List<String> getTags() {
        return tags;
    }

    public void setTags(final List<String> tags) {
        this.tags = tags;
    }

    public Set<String> getReleaseTags() {
        return releaseTags;
    }

    public void setReleaseTags(final Set<String> releaseTags) {
        this.releaseTags = releaseTags;
    }

    public String getStatusLine() {
        return statusLine;
    }

    public void setStatusLine(final String statusLine) {
        this.statusLine = statusLine;
    }

    public List<Facet> getFacets() {
        return facets;
    }

    public void setFacets(List<Facet> facets) {
        this.facets = facets;
    }

    public boolean getWaitForRelease() {
        return waitForRelease;
    }

    public void setWaitForRelease(final boolean waitForRelease) {
        this.waitForRelease = waitForRelease;
    }

    public int getScriptTimeout() {
        return scriptTimeout;
    }

    public void setScriptTimeout(int scriptTimeout) {
        this.scriptTimeout = scriptTimeout;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TaskFullView taskView = (TaskFullView) o;

        if (!Objects.equals(addedComment, taskView.addedComment)) return false;
        if (!Objects.equals(description, taskView.description)) return false;
        if (!Objects.equals(dueDate, taskView.dueDate)) return false;
        if (!Objects.equals(id, taskView.id)) return false;
        if (!Objects.equals(owner, taskView.owner)) return false;
        if (!Objects.equals(phaseTitle, taskView.phaseTitle)) return false;
        if (!Objects.equals(releaseTitle, taskView.releaseTitle)) return false;
        if (status != taskView.status) return false;
        if (!Objects.equals(type, taskView.type)) return false;
        if (!Objects.equals(tags, taskView.tags)) return false;
        return Objects.equals(title, taskView.title);
    }

    @Override
    public int hashCode() {
        int result = id != null ? id.hashCode() : 0;
        result = 31 * result + (title != null ? title.hashCode() : 0);
        result = 31 * result + (description != null ? description.hashCode() : 0);
        result = 31 * result + (owner != null ? owner.hashCode() : 0);
        result = 31 * result + (type != null ? type.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (dueDate != null ? dueDate.hashCode() : 0);
        result = 31 * result + (phaseTitle != null ? phaseTitle.hashCode() : 0);
        result = 31 * result + (releaseTitle != null ? releaseTitle.hashCode() : 0);
        result = 31 * result + (addedComment != null ? addedComment.hashCode() : 0);
        result = 31 * result + (tags != null ? tags.hashCode() : 0);
        return result;
    }

    public boolean isPostponedDueToBlackout() {
        return postponedDueToBlackout;
    }

    public void setPostponedDueToBlackout(boolean postponedDueToBlackout) {
        this.postponedDueToBlackout = postponedDueToBlackout;
    }

    public boolean isPostponedUntilEnvironmentsAreReserved() {
        return postponedUntilEnvironmentsAreReserved;
    }

    public TaskFullView setPostponedUntilEnvironmentsAreReserved(boolean postponedUntilEnvironmentsAreReserved) {
        this.postponedUntilEnvironmentsAreReserved = postponedUntilEnvironmentsAreReserved;
        return this;
    }

    public Date getOriginalScheduledStartDate() {
        return originalScheduledStartDate;
    }

    public void setOriginalScheduledStartDate(Date originalScheduledStartDate) {
        this.originalScheduledStartDate = originalScheduledStartDate;
    }

    public boolean isLocked() {
        return locked;
    }

    public void setLocked(final boolean locked) {
        this.locked = locked;
    }

    public boolean isCheckAttributes() {
        return checkAttributes;
    }

    public void setCheckAttributes(boolean checkAttributes) {
        this.checkAttributes = checkAttributes;
    }

    public boolean isKeepPreviousOutputPropertiesOnRetry() {
        return keepPreviousOutputPropertiesOnRetry;
    }

    public void setKeepPreviousOutputPropertiesOnRetry(final boolean keepPreviousOutputPropertiesOnRetry) {
        this.keepPreviousOutputPropertiesOnRetry = keepPreviousOutputPropertiesOnRetry;
    }

    public boolean isContainerTask() {
        return containerTask;
    }

    public void setContainerTask(boolean containerTask) {
        this.containerTask = containerTask;
    }

    public Set<UserView> getWatchers() {
        return watchers;
    }

    public void setWatchers(final Set<UserView> watchers) {
        this.watchers = watchers;
    }

    public UserView getLastStatusChangeBy() {
        return lastStatusChangeBy;
    }

    public void setLastStatusChangeBy(UserView lastStatusChangeBy) {
        this.lastStatusChangeBy = lastStatusChangeBy;
    }
}
