package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.domain.TemplateLogo
import com.xebialabs.xlrelease.repository.sql.persistence.CiUid

trait TemplateMetadataRepository {

  def createOrUpdate(templateMeta: TemplateMetadata): TemplateMetadata

  def update(releaseUid: CiUid, templateMetadata: TemplateMetadata): TemplateMetadata

  def createOrUpdateLogo(releaseUid: CiUid, templateLogo: TemplateLogo): TemplateLogo

  def delete(releaseUid: CiUid): Unit

  def find(releaseUid: CiUid): Option[TemplateMetadata]

  def findTemplateLogoById(logoId: String): Option[TemplateLogo]

}


case class TemplateMetadata(releaseUid: CiUid,
                            author: String,
                            description: String,
                            targetFolderId: String,
                            allowTargetFolderOverride: Boolean,
                            templateLogo: TemplateLogo)
