package com.xebialabs.xlrelease.domain;

import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;

public class StartWelcomeReleaseEvent implements XLReleaseEvent {
    private String welcomeUser;
    private String username;
    private String fullName;

    public StartWelcomeReleaseEvent(String welcomeUser, String fullName) {
        this.welcomeUser = welcomeUser;
        this.fullName = fullName;
    }

    public String getWelcomeUser() {
        return welcomeUser;
    }

    public String getFullName() {
        return fullName;
    }

    @Override
    public String toString() {
        return "StartWelcomeReleaseEvent{" +
                "username='" + welcomeUser + '\'' +
                '}';
    }

    @Override
    public String username() {
        return username;
    }

    @Override
    public void username_$eq(final String username) {
        this.username = username;
    }
}
