package com.xebialabs.xlrelease.script.builder

import com.xebialabs.xlrelease.config.XlrConfig
import com.xebialabs.xlrelease.domain.Task
import com.xebialabs.xlrelease.script.{ScriptTimeoutContext, XlrScript, XlrScriptContext}

import java.util.concurrent.ScheduledExecutorService
import scala.jdk.DurationConverters._

class FailureHandlerScriptContextBuilder(xlrConfig: XlrConfig, task: Task, timeoutExecutor: ScheduledExecutorService) extends ScriptContextBuilder {
  withScriptApi().withLogger().withExecutionId(task.getExecutionId)
  withPythonSugar().withPythonGlobals().withPythonReleaseApi().withPythonUtilities()
  val timeoutEnabled = true
  val timeout = xlrConfig.timeouts.failureHandlerTimeout.toJava
  withTimeoutContext(new ScriptTimeoutContext(timeoutEnabled, timeoutExecutor, timeout, "Failure handler script timed out."))

  override def doBuild(context: XlrScriptContext): Unit = {
    context.addDomainObjects(safe(task))

    val script = XlrScript.byContent(s"<failure_handler>${task.getType}[${task.getId}]", task.getFailureHandler, wrap = true, checkPermissions = true)
    context.addScript(script)
  }

}