package com.xebialabs.xlrelease.service;

import com.xebialabs.xlrelease.repository.SpringSessionRepository
import org.springframework.scheduling.annotation.{EnableScheduling, SchedulingConfigurer}
import org.springframework.scheduling.config.ScheduledTaskRegistrar
import org.springframework.stereotype.Service

import scala.concurrent.duration.DurationInt
import scala.jdk.DurationConverters._


@EnableScheduling
@Service
class EmptyPrincipalCleanupService(springSessionRepository: SpringSessionRepository) extends SchedulingConfigurer with NoopXlrServiceLifecycle {

  override def getOrder: Int = XlrServiceLifecycleOrder.EMPTY_PRINCIPAL_CLEANUP_SERVICE

  private def runCleanup(): Unit = {
    if (isRunning) {
      this.springSessionRepository.cleanUpSessionsWithEmptyPrincipal();
    }
  }

  override def configureTasks(taskRegistrar: ScheduledTaskRegistrar): Unit = {
    val delayDuration = 5.minutes
    taskRegistrar.addFixedDelayTask(() => this.runCleanup(), delayDuration.toJava);
  }
}
