package com.xebialabs.xlrelease.scheduler.events

import com.xebialabs.xlrelease.domain.distributed.events.DistributedXLReleaseEvent
import com.xebialabs.xlrelease.domain.runner.JobRunner
import com.xebialabs.xlrelease.scheduler.Job

/**
 * Common interface for events related to job execution or modification.
 */
sealed trait JobEvent extends DistributedXLReleaseEvent

/**
 * Event published when a job is created.
 *
 * @param job the created job.
 */
case class JobCreatedEvent(job: Job) extends JobEvent

/**
 * Event published when a job is reserved.
 *
 * @param jobId the reserved job id.
 */
case class JobReservedEvent(jobId: Long) extends JobEvent

/**
 * Event published when a job execution is requested to abort.
 *
 * @param jobId the job id.
 * @param executionId the execution id.
 */
case class JobExecutionAbortRequestEvent(jobId: Long, executionId: String) extends JobEvent

/**
 * Event published when job is finished.
 *
 * @param jobId the id of finished job.
 */
case class JobFinishedEvent(executionId: String, jobId: Long) extends JobEvent

sealed trait JobRunnerEvent extends DistributedXLReleaseEvent

case class JobRunnerCreatedOrUpdatedEvent(jobRunner: JobRunner) extends JobRunnerEvent

case class JobRunnerDeletedEvent(jobRunner: JobRunner) extends JobRunnerEvent
