package com.xebialabs.xlrelease.domain.tasks.script;

import org.springframework.stereotype.Component;

import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.tasks.BaseScriptTaskExecutor;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.WorkManager;
import com.xebialabs.xlrelease.script.TaskSoftReference;

@Component
public class ScriptTaskExecutor extends BaseScriptTaskExecutor<ResolvableScriptTask> {

    public ScriptTaskExecutor(WorkManager workManager, TaskRepository taskRepository) {
        super(workManager, taskRepository);
    }

    @Override
    public Class<? extends ScriptTask> getTaskClass() {
        return ScriptTask.class;
    }

    @Override
    public void execute(TaskSoftReference<ResolvableScriptTask> taskRef) {
        workManager.submit(new ScriptTaskJob(taskRef));
    }
}
