/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.domain.tasks.TaskUpdateDirective;
import com.xebialabs.xlrelease.exception.LogFriendlyConcurrentModificationException;
import com.xebialabs.xlrelease.repository.UserProfileRepository;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskConcurrencyService {
    private final UserProfileRepository userProfileRepository;

    @Autowired
    public TaskConcurrencyService(UserProfileRepository userProfileRepository) {
        this.userProfileRepository = userProfileRepository;
    }

    public void updateLastModifiedDetails(Task task) {
        task.set$ciAttributes(new CiAttributes(task.get$ciAttributes().getCreatedBy(), task.get$ciAttributes().getCreatedAt(), Permissions.getAuthenticatedUserName(), DateTime.now().withZone(DateTimeZone.UTC), task.get$ciAttributes().getScmTraceabilityDataId()));
    }

    public void checkConcurrentModification(Task existingTask, Task updatedTask, Set<TaskUpdateDirective> updateDirectives) {
        if (updateDirectives.contains((Object)TaskUpdateDirective.UPDATE_VERIFY_CONCURRENT_MODIFICATION)) {
            CiAttributes existingTaskAttributes = existingTask.get$ciAttributes();
            CiAttributes updatedTaskAttributes = updatedTask.get$ciAttributes();
            if (this.isLastUpdatedByDifferentUser(existingTaskAttributes.getLastModifiedBy()) && this.isUpdatedTaskVersionOutdated(existingTaskAttributes.getLastModifiedAt(), updatedTaskAttributes.getLastModifiedAt())) {
                throw new LogFriendlyConcurrentModificationException(this.formatExceptionMessage(existingTaskAttributes), new Object[0]);
            }
        }
    }

    public void checkConcurrentModification(Task existingTask, DateTime modifiedAt) {
        CiAttributes existingTaskAttributes = existingTask.get$ciAttributes();
        if (this.isLastUpdatedByDifferentUser(existingTaskAttributes.getLastModifiedBy()) && this.isUpdatedTaskVersionOutdated(existingTaskAttributes.getLastModifiedAt(), modifiedAt)) {
            throw new LogFriendlyConcurrentModificationException(this.formatExceptionMessage(existingTaskAttributes), new Object[0]);
        }
    }

    private boolean isLastUpdatedByDifferentUser(String originalModifiedBy) {
        if (originalModifiedBy == null) {
            return true;
        }
        return originalModifiedBy.compareToIgnoreCase(Permissions.getAuthenticatedUserName()) != 0;
    }

    private boolean isUpdatedTaskVersionOutdated(DateTime originalModDate, DateTime updatedModDate) {
        return originalModDate != null && updatedModDate != null && originalModDate.isAfter((ReadableInstant)updatedModDate.withZone(DateTimeZone.UTC)) || originalModDate != null && updatedModDate == null;
    }

    private String formatExceptionMessage(CiAttributes ciAttributes) {
        return String.format("This task has been modified by %s %s ago. Refresh the task to see the most recent version and apply the changes.", this.getLastModifiedByUser(ciAttributes.getLastModifiedBy()), this.formatTimeSinceLastChange(ciAttributes.getLastModifiedAt().withZone(DateTimeZone.UTC)));
    }

    private String getLastModifiedByUser(String lastModifiedBy) {
        if (lastModifiedBy == null) {
            return "Unknown";
        }
        UserProfile userProfile = (UserProfile)this.userProfileRepository.findById(lastModifiedBy.toLowerCase()).getOrElse(() -> null);
        return userProfile != null && userProfile.getFullName() != null && !userProfile.getFullName().isEmpty() ? userProfile.getFullName() : lastModifiedBy;
    }

    private String formatTimeSinceLastChange(DateTime dateTime) {
        long timeSinceLastUpdate = DateTime.now().withZone(DateTimeZone.UTC).getMillis() - dateTime.getMillis();
        if (timeSinceLastUpdate < 60000L) {
            return String.format("%d second(s)", timeSinceLastUpdate / 1000L);
        }
        if (timeSinceLastUpdate < 3600000L) {
            return String.format("%d minute(s)", timeSinceLastUpdate / 60000L);
        }
        if (timeSinceLastUpdate < 86400000L) {
            return String.format("%d hour(s)", timeSinceLastUpdate / 3600000L);
        }
        return String.format("%d day(s)", timeSinceLastUpdate / 86400000L);
    }
}

