package com.xebialabs.xlrelease.security.sql.snapshots.domain

import java.util.Date

object RolesSnapshot {
  def empty: RolesSnapshot = RolesSnapshot(new Date, None, None, isInherited = false)
}

case class RolesSnapshot(
                          snapshotDate: Date,
                          containerIdName: Option[String],
                          rolesAndPermissions: Option[Seq[RoleWithPrincipalsAndPermissions]],
                          isInherited: Boolean,
                          parentContainerIdName: Option[String] = None
                        )

case class RoleWithPrincipalsAndPermissions(
                                           id: String,
                                           name: String,
                                           principals: Seq[String],
                                           roleIds: Seq[String],
                                           permissions: Seq[String]
                                           )

case class GlobalRolesForPrincipalAndPermission(principal: String, fullName: String, permission: String, roles: Seq[String])

case class ContainerTeamsAndRolesForPrincipalAndPermission(principal: String, fullName: String, permission: String, links: Seq[String])
