/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.rest.mappers;

import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.xebialabs.deployit.Exceptions;
import com.xebialabs.deployit.Sanitizer;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.springframework.stereotype.Component;

@Component
public class StreamConstraintsExceptionMapper
implements ExceptionMapper<StreamConstraintsException> {
    public static final String MAX_STR_LENGTH_ERROR_MSG = "The specified string exceeds the maximum allowed string length. Please reduce the string length and retry. If further assistance is needed please reach out to customer support.";

    public Response toResponse(StreamConstraintsException e) {
        String content = Exceptions.getAllMessages((Exception)e);
        boolean containsMaxStringLengthError = e.getMessage().contains("StreamReadConstraints.getMaxStringLength()");
        if (containsMaxStringLengthError) {
            content = MAX_STR_LENGTH_ERROR_MSG;
        }
        Response.ResponseBuilder builder = Response.serverError().type("text/plain");
        builder.entity((Object)Sanitizer.sanitize((String)content));
        return builder.build();
    }
}

