package com.xebialabs.xlrelease.views;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdDeserializer;
import com.xebialabs.xlrelease.serialization.json.jackson.DomainIdSerializer;

public class PhaseOverview {

    @JsonSerialize(using = DomainIdSerializer.class)
    @JsonDeserialize(using = DomainIdDeserializer.class)
    protected String id;

    protected String title;

    private PhaseStatus status;
    private String color;

    private Long totalTasks;

    private Long tasksCompleted;

    public String getId() {
        return id;
    }

    public void setId(final String id) {
        this.id = id;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(final String title) {
        this.title = title;
    }

    public PhaseStatus getStatus() {
        return status;
    }

    public void setStatus(final PhaseStatus status) {
        this.status = status;
    }

    public String getColor() {
        return color;
    }

    public void setColor(final String color) {
        this.color = color;
    }

    public Long getTotalTasks() {
        return totalTasks;
    }

    public void setTotalTasks(final Long totalTasks) {
        this.totalTasks = totalTasks;
    }

    public Long getTasksCompleted() {
        return tasksCompleted;
    }

    public void setTasksCompleted(final Long tasksCompleted) {
        this.tasksCompleted = tasksCompleted;
    }
}
