package com.xebialabs.xlrelease.principaldata;

import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;

/**
 * Retrieves a principal's data from an external source.
 */
public interface PrincipalDataProvider {
    UserData getUserData(String username);

    String getGroupEmail(String groupName);

    Collection<? extends GrantedAuthority> getAuthorities(String username);

    void invalidate(String username);
}
