package com.xebialabs.xlrelease.script;

import java.util.Collection;

import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.variables.ScriptValueProviderConfiguration;

public interface ScriptService {

    Object executeScript(XlrScriptContext scriptContext) throws Exception;

    <T extends ResolvableScriptTask> ScriptTaskResult executeScriptTask(T task);

    <T extends CustomScriptTask> CustomScriptTaskResult executeCustomScriptTask(T task);

    PreconditionResult executePrecondition(Task task);

    FacetCheckResult executeFacetCheck(Task task);

    FailureHandlerResult executeFailureHandler(Task task);

    Collection<Object> executeScriptValueProvider(ScriptValueProviderConfiguration valueProviderConfiguration);

    String engine();

    boolean accepts(String filename);
}
