package com.xebialabs.xlrelease.features

import com.xebialabs.xlrelease.features.distributed.{BaseDistributedFeature, DistributedFeature}
import com.xebialabs.xlrelease.features.settings.DatabaseProxyFeatureSettings

import scala.concurrent.duration.{DurationLong, FiniteDuration}

trait DatabaseProxyFeature  extends DistributedFeature {
  def isSpyProxyEnabled: Boolean

  def executionThreshold: FiniteDuration

  def shouldLogParameters: Boolean
}

object DatabaseProxyFeature
  extends BaseDistributedFeature[DatabaseProxyFeatureSettings]
    with DatabaseProxyFeature {
  override def isSpyProxyEnabled: Boolean = featureSettings.enableStatementLog

  override def executionThreshold: FiniteDuration = featureSettings.executionThresholdMs.toLong.millis

  override def shouldLogParameters: Boolean = featureSettings.logParameters
}