/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.events.handlers;

import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.events.ConfigurationCopiedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationDeletedEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationEvent;
import com.xebialabs.xlrelease.domain.events.ConfigurationUpdatedEvent;
import com.xebialabs.xlrelease.domain.runner.JobRunner;
import com.xebialabs.xlrelease.domain.runner.RemoteRunnerRegistrySettings;
import com.xebialabs.xlrelease.events.AsyncSubscribe;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.repository.JobRunnerRepository;
import com.xebialabs.xlrelease.scheduler.RunnerRegistry;
import com.xebialabs.xlrelease.scheduler.events.JobRunnerCreatedOrUpdatedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobRunnerDeletedEvent;
import com.xebialabs.xlrelease.scheduler.events.JobRunnerEvent;
import com.xebialabs.xlrelease.service.BroadcastService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001\u0002\u0007\u000e\u0001iA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\ta\u0001\u0011\t\u0011)A\u0005c!Aq\u0007\u0001B\u0001B\u0003%\u0001\bC\u0003=\u0001\u0011\u0005Q\bC\u0003D\u0001\u0011\u0005A\tC\u0003X\u0001\u0011\u0005\u0001\fC\u0003`\u0001\u0011\u0005\u0001\rC\u0003g\u0001\u0011%q\rC\u0003q\u0001\u0011%\u0011\u000fC\u0003s\u0001\u0011%1\u000fC\u0003z\u0001\u0011%!PA\u000bK_\n\u0014VO\u001c8fe\u00163XM\u001c;IC:$G.\u001a:\u000b\u00059y\u0011\u0001\u00035b]\u0012dWM]:\u000b\u0005A\t\u0012AB3wK:$8O\u0003\u0002\u0013'\u0005I1o\u00195fIVdWM\u001d\u0006\u0003)U\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011c\u0001\u0001\u001cCA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\u000bMdg\r\u000e6\u000b\u0003\u0019\n\u0001b\u001a:jujdW\rZ\u0005\u0003Q\r\u0012q\u0001T8hO&tw-\u0001\tce>\fGmY1tiN+'O^5dKB\u00111FL\u0007\u0002Y)\u0011QfE\u0001\bg\u0016\u0014h/[2f\u0013\tyCF\u0001\tCe>\fGmY1tiN+'O^5dK\u0006\u0019\"n\u001c2Sk:tWM\u001d*fa>\u001c\u0018\u000e^8ssB\u0011!'N\u0007\u0002g)\u0011AgE\u0001\u000be\u0016\u0004xn]5u_JL\u0018B\u0001\u001c4\u0005MQuN\u0019*v]:,'OU3q_NLGo\u001c:z\u00039\u0011XO\u001c8feJ+w-[:uef\u0004\"!\u000f\u001e\u000e\u0003EI!aO\t\u0003\u001dI+hN\\3s%\u0016<\u0017n\u001d;ss\u00061A(\u001b8jiz\"BA\u0010!B\u0005B\u0011q\bA\u0007\u0002\u001b!)\u0011\u0006\u0002a\u0001U!)\u0001\u0007\u0002a\u0001c!)q\u0007\u0002a\u0001q\u0005\u0011rN\u001c&pEJ+hN\\3s\u0007J,\u0017\r^3e)\t)\u0005\n\u0005\u0002\u001d\r&\u0011q)\b\u0002\u0005+:LG\u000fC\u0003J\u000b\u0001\u0007!*A\u0003fm\u0016tG\u000f\u0005\u0002L\u001f6\tAJ\u0003\u0002\u0011\u001b*\u0011ajE\u0001\u0007I>l\u0017-\u001b8\n\u0005Ac%AE\"p]\u001aLw-\u001e:bi&|g.\u0012<f]RD#!\u0002*\u0011\u0005M+V\"\u0001+\u000b\u0005A\u0019\u0012B\u0001,U\u0005%\u0019VOY:de&\u0014W-\u0001\tp]*{'MU;o]\u0016\u0014XI^3oiR\u0011Q)\u0017\u0005\u0006\u0013\u001a\u0001\rA\u0017\t\u00037rk\u0011aD\u0005\u0003;>\u0011aBS8c%Vtg.\u001a:Fm\u0016tG\u000f\u000b\u0002\u0007%\u0006)rN\\\"p]\u001aLw-\u001e:bi&|g.\u00169eCR,GCA#b\u0011\u0015Iu\u00011\u0001KQ\t91\r\u0005\u0002TI&\u0011Q\r\u0016\u0002\u000f\u0003NLhnY*vEN\u001c'/\u001b2f\u0003Q)\b\u000fZ1uKJ+hN\\3s'\u0016$H/\u001b8hgR\u0011Q\t\u001b\u0005\u0006S\"\u0001\rA[\u0001\bkB$\u0017\r^3e!\tYg.D\u0001m\u0015\tiW*\u0001\u0004sk:tWM]\u0005\u0003_2\u0014ADU3n_R,'+\u001e8oKJ\u0014VmZ5tiJL8+\u001a;uS:<7/\u0001\u000beK2,G/\u001a*v]:,'oU3ui&twm\u001d\u000b\u0002\u000b\u0006q!/Z4jgR,'OU;o]\u0016\u0014HCA#u\u0011\u0015)(\u00021\u0001w\u0003%QwN\u0019*v]:,'\u000f\u0005\u0002lo&\u0011\u0001\u0010\u001c\u0002\n\u0015>\u0014'+\u001e8oKJ\f\u0001#\u001e8sK\u001eL7\u000f^3s%Vtg.\u001a:\u0015\u0007\u0015[H\u0010C\u0003v\u0017\u0001\u0007a\u000fC\u0003~\u0017\u0001\u0007a0\u0001\u0007eK2,G/\u001a*v]:,'\u000f\u0005\u0002\u001d\u007f&\u0019\u0011\u0011A\u000f\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0001!!\u0002\u0011\t\u0005\u001d\u0011QC\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005Q1\u000f^3sK>$\u0018\u0010]3\u000b\t\u0005=\u0011\u0011C\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011\u00111C\u0001\u0004_J<\u0017\u0002BA\f\u0003\u0013\u0011qaU3sm&\u001cW\rK\u0002\u0001\u00037\u00012aUA\u000f\u0013\r\ty\u0002\u0016\u0002\u000e\u000bZ,g\u000e\u001e'jgR,g.\u001a:")
public class JobRunnerEventHandler
implements Logging {
    private final BroadcastService broadcastService;
    private final JobRunnerRepository jobRunnerRepository;
    private final RunnerRegistry runnerRegistry;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        JobRunnerEventHandler jobRunnerEventHandler = this;
        synchronized (jobRunnerEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void onJobRunnerCreated(ConfigurationEvent event2) {
        ConfigurationCopiedEvent configurationCopiedEvent;
        BaseConfiguration original;
        ConfigurationDeletedEvent configurationDeletedEvent;
        BaseConfiguration conf;
        ConfigurationUpdatedEvent configurationUpdatedEvent;
        BaseConfiguration updated;
        Some some;
        ConfigurationCreatedEvent configurationCreatedEvent;
        BaseConfiguration conf2;
        ConfigurationEvent configurationEvent = event2;
        if (configurationEvent instanceof ConfigurationCreatedEvent && (conf2 = (configurationCreatedEvent = (ConfigurationCreatedEvent)configurationEvent).conf()) instanceof JobRunner) {
            JobRunner jobRunner = (JobRunner)conf2;
            some = new Some((Object)new JobRunnerCreatedOrUpdatedEvent(jobRunner));
        } else if (configurationEvent instanceof ConfigurationUpdatedEvent && (updated = (configurationUpdatedEvent = (ConfigurationUpdatedEvent)configurationEvent).updated()) instanceof JobRunner) {
            JobRunner jobRunner = (JobRunner)updated;
            some = new Some((Object)new JobRunnerCreatedOrUpdatedEvent(jobRunner));
        } else if (configurationEvent instanceof ConfigurationDeletedEvent && (conf = (configurationDeletedEvent = (ConfigurationDeletedEvent)configurationEvent).conf()) instanceof JobRunner) {
            JobRunner jobRunner = (JobRunner)conf;
            some = new Some((Object)new JobRunnerDeletedEvent(jobRunner));
        } else if (configurationEvent instanceof ConfigurationCopiedEvent && (original = (configurationCopiedEvent = (ConfigurationCopiedEvent)configurationEvent).original()) instanceof JobRunner) {
            JobRunner jobRunner = (JobRunner)original;
            some = new Some((Object)new JobRunnerCreatedOrUpdatedEvent(jobRunner));
        } else {
            some = None$.MODULE$;
        }
        Some runnerEvent = some;
        runnerEvent.foreach((Function1 & Serializable)event -> {
            this.broadcastService.broadcast(event, true);
            return BoxedUnit.UNIT;
        });
    }

    @Subscribe
    public void onJobRunnerEvent(JobRunnerEvent event) {
        JobRunnerEvent jobRunnerEvent = event;
        if (jobRunnerEvent instanceof JobRunnerCreatedOrUpdatedEvent) {
            JobRunnerCreatedOrUpdatedEvent jobRunnerCreatedOrUpdatedEvent = (JobRunnerCreatedOrUpdatedEvent)jobRunnerEvent;
            JobRunner jobRunner = jobRunnerCreatedOrUpdatedEvent.jobRunner();
            if (jobRunner.isEnabled() && Predef$.MODULE$.Integer2int(jobRunner.capacity()) > 0 && jobRunner.isAvailable()) {
                this.registerRunner(jobRunner);
                return;
            }
            this.unregisterRunner(jobRunner, false);
            return;
        }
        if (jobRunnerEvent instanceof JobRunnerDeletedEvent) {
            JobRunnerDeletedEvent jobRunnerDeletedEvent = (JobRunnerDeletedEvent)jobRunnerEvent;
            JobRunner jobRunner = jobRunnerDeletedEvent.jobRunner();
            this.unregisterRunner(jobRunner, true);
            return;
        }
        throw new MatchError((Object)jobRunnerEvent);
    }

    @AsyncSubscribe
    public void onConfigurationUpdate(ConfigurationEvent event) {
        ConfigurationDeletedEvent configurationDeletedEvent;
        BaseConfiguration deleted;
        ConfigurationUpdatedEvent configurationUpdatedEvent;
        BaseConfiguration updated;
        ConfigurationEvent configurationEvent = event;
        if (configurationEvent instanceof ConfigurationUpdatedEvent && (updated = (configurationUpdatedEvent = (ConfigurationUpdatedEvent)configurationEvent).updated()) instanceof RemoteRunnerRegistrySettings) {
            RemoteRunnerRegistrySettings remoteRunnerRegistrySettings = (RemoteRunnerRegistrySettings)updated;
            this.updateRunnerSettings(remoteRunnerRegistrySettings);
            return;
        }
        if (configurationEvent instanceof ConfigurationDeletedEvent && (deleted = (configurationDeletedEvent = (ConfigurationDeletedEvent)configurationEvent).conf()) instanceof RemoteRunnerRegistrySettings) {
            this.deleteRunnerSettings();
            return;
        }
    }

    private void updateRunnerSettings(RemoteRunnerRegistrySettings updated) {
        ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(this.jobRunnerRepository.findAll()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JobRunnerEventHandler.$anonfun$updateRunnerSettings$1(updated, x$1)))).foreach((Function1 & Serializable)x$2 -> {
            x$2.configure();
            return BoxedUnit.UNIT;
        });
    }

    private void deleteRunnerSettings() {
        CollectionConverters$.MODULE$.ListHasAsScala(this.jobRunnerRepository.findAll()).asScala().foreach((Function1 & Serializable)x$3 -> {
            x$3.configure();
            return BoxedUnit.UNIT;
        });
    }

    private void registerRunner(JobRunner jobRunner) {
        Success success;
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.runnerRegistry.registerJobRunner(jobRunner));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.logger().error((Function0 & Serializable)() -> "Unable to register job runner [" + jobRunner.getId() + "]", (Function0 & Serializable)() -> ex);
            jobRunner.stop();
            return;
        }
        if (try_ instanceof Success && (bl = BoxesRunTime.unboxToBoolean((Object)(success = (Success)try_).value()))) {
            this.logger().debug((Function0 & Serializable)() -> "Successfully registered job runner [" + jobRunner.getId() + "]. Going to start it.");
            jobRunner.configure();
            jobRunner.start();
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "Job runner already in queue [" + jobRunner.getId() + "]. Skipping start.");
    }

    private void unregisterRunner(JobRunner jobRunner, boolean deleteRunner) {
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.runnerRegistry.unregisterJobRunner(jobRunner));
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            this.logger().error((Function0 & Serializable)() -> "Unable to unregister job runner [" + jobRunner.getId() + "]", (Function0 & Serializable)() -> ex);
        } else if (try_ instanceof Success) {
            this.logger().trace((Function0 & Serializable)() -> "Unregistered job runner [" + jobRunner.getId() + "]");
        } else {
            throw new MatchError((Object)try_);
        }
        if (deleteRunner) {
            jobRunner.delete();
            return;
        }
        jobRunner.stop();
    }

    public static final /* synthetic */ boolean $anonfun$updateRunnerSettings$1(RemoteRunnerRegistrySettings updated$1, JobRunner x$1) {
        String string = x$1.registrySettings().getId();
        String string2 = updated$1.getId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JobRunnerEventHandler(BroadcastService broadcastService, JobRunnerRepository jobRunnerRepository, RunnerRegistry runnerRegistry) {
        this.broadcastService = broadcastService;
        this.jobRunnerRepository = jobRunnerRepository;
        this.runnerRegistry = runnerRegistry;
        Logging.$init$((Logging)this);
    }
}

