package com.xebialabs.xlrelease.service

import com.xebialabs.xlrelease.domain._
import com.xebialabs.xlrelease.domain.status.TaskStatus
import com.xebialabs.xlrelease.domain.variables.Variable
import com.xebialabs.xlrelease.script._
import com.xebialabs.xlrelease.user.User
import io.micrometer.core.annotation.Timed

import java.util
import java.util.Date


trait ExecutionService {

  @Timed
  def start(release: Release, user: User): Release = {
    // this method seems to be used only in tests
    start(release, user, releaseStartedImmediatelyAfterBeingCreated = false, isPartOfBulkOperation = false)
  }

  def start(release: Release, user: User, releaseStartedImmediatelyAfterBeingCreated: Boolean, isPartOfBulkOperation: Boolean): Release

  def resume(releaseId: String): Release

  def abort(releaseId: String, abortComment: String, isPartOfBulkOperation: Boolean): Release

  def startPendingTask(taskId: String, release: Release, comment: String, user: User): Unit

  def postponeUntilEnvironmentsAreReserved(taskId: String, postponeUntil: Date, comment: String, executionId: String): Unit

  def fail(task: Task,
           addedComment: String,
           baseScriptTaskResults: Option[DefaultScriptService.BaseScriptTaskResults],
           user: User,
           executionId: Option[String]): Unit

  def fail(task: Task, addedComment: String, user: User): Unit

  def scriptFailed(task: Task,
                   scriptFailMessage: String,
                   scriptExecutionId: String,
                   logArtifactId: Option[String],
                   scriptResults: Option[DefaultScriptService.BaseScriptTaskResults],
                   user: User): Unit

  def saveCustomScriptResults(release: Release,
                              taskId: String,
                              results: DefaultScriptService.CustomScriptTaskResults,
                              executionId: String): Unit

  def resumeTask(taskId: String): Unit

  def abortTask(task: Task, addedComment: String): Unit

  def skipTaskDueToPreconditionCheck(release: Release, taskId: String, executionId: String, executionLog: String): Unit

  def markTaskAsDone(release: Release, targetStatus: TaskStatus, taskId: String, addedComment: String, user: User): Unit

  def markTaskAsDone(release: Release,
                     targetStatus: TaskStatus,
                     taskId: String,
                     addedComment: String,
                     logArtifactId: Option[String],
                     scriptResults: Option[DefaultScriptService.BaseScriptTaskResults],
                     user: User): Unit

  def markTaskAsDone(release: Release,
                     targetStatus: TaskStatus,
                     taskId: String,
                     addedComment: String,
                     logArtifactId: Option[String],
                     scriptResults: Option[DefaultScriptService.BaseScriptTaskResults],
                     user: User,
                     executionId: String): Boolean


  def finishCustomScriptTask(release: Release,
                             taskId: String,
                             comment: String,
                             executionId: String,
                             logArtifactId: Option[String],
                             scriptResults: Option[DefaultScriptService.BaseScriptTaskResults]): Unit

  def finishScriptTask(release: Release,
                       taskId: String,
                       comment: String,
                       executionId: String,
                       logArtifactId: Option[String],
                       scriptResults: Option[DefaultScriptService.BaseScriptTaskResults]): Unit

  def finishContainerTask(release: Release,
                          taskId: String,
                          taskResult: ContainerTaskResult): Unit

  def taskPreconditionValidated(taskId: String, release: Release, executionId: String): Unit

  def reopenTask(task: Task, addedComment: String): Unit

  def retry(task: Task, addedComment: String): Unit

  def startWithInput(taskId: String, variables: util.List[Variable]): Task

  def updateGateTaskStatus(release: Release, gateTask: GateTask): Unit
}
